/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.slabs;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcretePowderSlab
extends FallingBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.f_61397_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ConcretePowderSlab(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    private static boolean shouldSolidify(BlockGetter reader, BlockPos pos, BlockState state) {
        return ConcretePowderSlab.canSolidify(state) || ConcretePowderSlab.touchesLiquid(reader, pos);
    }

    private static boolean touchesLiquid(BlockGetter reader, BlockPos pos) {
        boolean flag = false;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (Direction direction : Direction.values()) {
            BlockState blockstate = reader.m_8055_((BlockPos)mutable);
            if (direction == Direction.DOWN && !ConcretePowderSlab.canSolidify(blockstate)) continue;
            mutable.m_122159_((Vec3i)pos, direction);
            blockstate = reader.m_8055_((BlockPos)mutable);
            if (!ConcretePowderSlab.canSolidify(blockstate) || blockstate.m_60783_(reader, pos, direction.m_122424_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean canSolidify(BlockState state) {
        return state.m_60819_().m_76153_((Tag)FluidTags.f_13131_);
    }

    private BlockState getSolidifiedState() {
        String[] part = this.getRegistryName().m_135815_().split("_powder");
        String name = part[0] + part[1];
        return ((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135822_((String)("vanillaextension:" + name), (char)':'))).m_49966_();
    }

    public void m_142216_(Level worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingBlock) {
        if (ConcretePowderSlab.shouldSolidify((BlockGetter)worldIn, pos, hitState)) {
            worldIn.m_7731_(pos, (BlockState)((BlockState)this.getSolidifiedState().m_61124_(TYPE, (Comparable)((SlabType)fallingState.m_61143_(TYPE)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)fallingState.m_61143_((Property)WATERLOGGED))), 3);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return ConcretePowderSlab.touchesLiquid((BlockGetter)worldIn, currentPos) ? (BlockState)((BlockState)this.getSolidifiedState().m_61124_(TYPE, (Comparable)((SlabType)stateIn.m_61143_(TYPE)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        SlabType slabtype = (SlabType)state.m_61143_(TYPE);
        return switch (slabtype) {
            case SlabType.DOUBLE -> Shapes.m_83144_();
            case SlabType.TOP -> TOP_SHAPE;
            default -> BOTTOM_SHAPE;
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos;
        Level iblockreader = context.m_43725_();
        BlockState blockstate = iblockreader.m_8055_(blockpos = context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)((BlockState)blockstate.m_61124_(TYPE, (Comparable)SlabType.DOUBLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        BlockState blockstate2 = (BlockState)((BlockState)this.getSolidifiedState().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        Direction direction = context.m_43719_();
        if (ConcretePowderSlab.shouldSolidify((BlockGetter)iblockreader, blockpos, blockstate)) {
            return !(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? blockstate2 : (BlockState)blockstate2.m_61124_(TYPE, (Comparable)SlabType.TOP);
        }
        return !(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? blockstate1 : (BlockState)blockstate1.m_61124_(TYPE, (Comparable)SlabType.TOP);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        SlabType slabtype = (SlabType)state.m_61143_(TYPE);
        if (slabtype != SlabType.DOUBLE && itemstack.m_41720_() == this.m_5456_()) {
            if (useContext.m_7058_()) {
                boolean flag = useContext.m_43720_().f_82480_ - (double)useContext.m_8083_().m_123342_() > 0.5;
                Direction direction = useContext.m_43719_();
                if (slabtype == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.m_122434_().m_122479_();
                }
                return direction == Direction.DOWN || !flag && direction.m_122434_().m_122479_();
            }
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE && super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE && super.m_6044_(worldIn, pos, state, fluidIn);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && worldIn.m_6425_(pos).m_76153_((Tag)FluidTags.f_13131_);
    }
}

