/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.slabs;

import com.ketheroth.vanillaextension.init.SlabInit;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FarmSlab
extends FarmBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.f_61397_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public FarmSlab(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(0)));
    }

    public static void turnToDirtSlab(BlockState state, Level worldIn, BlockPos pos) {
        BlockState bs = (BlockState)((BlockState)((Block)SlabInit.dirt_slab.get()).m_49966_().m_61124_(TYPE, (Comparable)((SlabType)state.m_61143_(TYPE)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
        worldIn.m_46597_(pos, bs);
    }

    private static boolean hasWater(LevelReader worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-4, 0, -4), (BlockPos)pos.m_142082_(4, 1, 4))) {
            if (!worldIn.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13131_)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)worldIn, (BlockPos)pos);
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED, f_53243_});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        SlabType slabtype = (SlabType)state.m_61143_(TYPE);
        return switch (slabtype) {
            case SlabType.DOUBLE -> Shapes.m_83144_();
            case SlabType.TOP -> TOP_SHAPE;
            default -> BOTTOM_SHAPE;
        };
    }

    public BlockState getStateForPlacementSlab(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = context.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)((BlockState)blockstate.m_61124_(TYPE, (Comparable)SlabType.DOUBLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        Direction direction = context.m_43719_();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? blockstate1 : (BlockState)blockstate1.m_61124_(TYPE, (Comparable)SlabType.TOP);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((Block)SlabInit.dirt_slab.get()).m_49966_() : this.getStateForPlacementSlab(context);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        SlabType slabtype = (SlabType)state.m_61143_(TYPE);
        if (slabtype != SlabType.DOUBLE && itemstack.m_41720_() == this.m_5456_()) {
            if (useContext.m_7058_()) {
                boolean flag = useContext.m_43720_().f_82480_ - (double)useContext.m_8083_().m_123342_() > 0.5;
                Direction direction = useContext.m_43719_();
                if (slabtype == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.m_122434_().m_122479_();
                }
                return direction == Direction.DOWN || !flag && direction.m_122434_().m_122479_();
            }
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE && super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE && super.m_6044_(worldIn, pos, state, fluidIn);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == Direction.UP && !stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && worldIn.m_6425_(pos).m_76153_((Tag)FluidTags.f_13131_);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.m_142300_(facing));
        return PlantType.CROP.equals(type);
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        int i = (Integer)state.m_61143_((Property)f_53243_);
        if (!FarmSlab.hasWater((LevelReader)worldIn, pos) && !worldIn.m_46758_(pos.m_7494_())) {
            if (i > 0) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops((BlockGetter)worldIn, pos)) {
                FarmSlab.turnToDirtSlab(state, (Level)worldIn, pos);
            }
        } else if (i < 7) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    private boolean hasCrops(BlockGetter worldIn, BlockPos pos) {
        BlockState state = worldIn.m_8055_(pos.m_7494_());
        return state.m_60734_() instanceof IPlantable && this.canSustainPlant(state, worldIn, pos, Direction.UP, (IPlantable)state.m_60734_());
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.f_46443_ && ForgeHooks.onFarmlandTrample((Level)worldIn, (BlockPos)pos, (BlockState)Blocks.f_50493_.m_49966_(), (float)fallDistance, (Entity)entityIn)) {
            FarmSlab.turnToDirtSlab(worldIn.m_8055_(pos), worldIn, pos);
        }
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance);
    }
}

