/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.slabs;

import com.ketheroth.vanillaextension.init.FenceInit;
import com.ketheroth.vanillaextension.init.SlabInit;
import com.ketheroth.vanillaextension.init.StairsInit;
import com.ketheroth.vanillaextension.init.TrapdoorInit;
import com.ketheroth.vanillaextension.init.WallInit;
import com.ketheroth.vanillaextension.slabs.DirtSlab;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.LayerLightEngine;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GrassBlockSlab
extends DirtSlab
implements BonemealableBlock {
    public GrassBlockSlab(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean isSnowyConditions(BlockState state, LevelReader worldReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = worldReader.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50125_) && (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockstate.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LayerLightEngine.m_75667_((BlockGetter)worldReader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)worldReader, blockpos));
        return i < worldReader.m_7469_();
    }

    private static boolean isSnowyAndNotUnderwater(BlockState state, LevelReader worldReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return GrassBlockSlab.isSnowyConditions(state, worldReader, pos) && !worldReader.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13131_);
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return worldIn.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        if (((SlabType)state.m_61143_((Property)f_56353_)).equals((Object)SlabType.TOP) || ((SlabType)state.m_61143_((Property)f_56353_)).equals((Object)SlabType.DOUBLE)) {
            BlockPos blockpos = pos.m_7494_();
            BlockState blockstate = Blocks.f_50034_.m_49966_();
            block0: for (int i = 0; i < 128; ++i) {
                PlacedFeature placedfeature;
                BlockPos blockpos1 = blockpos;
                for (int j = 0; j < i / 16; ++j) {
                    if (!worldIn.m_8055_((blockpos1 = blockpos1.m_142082_(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).m_7495_()).m_60713_((Block)this) || worldIn.m_8055_(blockpos1).m_60838_((BlockGetter)worldIn, blockpos1)) continue block0;
                }
                BlockState blockstate2 = worldIn.m_8055_(blockpos1);
                if (blockstate2.m_60713_(blockstate.m_60734_()) && rand.nextInt(10) == 0) {
                    ((BonemealableBlock)blockstate.m_60734_()).m_7719_(worldIn, rand, blockpos1, blockstate2);
                }
                if (!blockstate2.m_60795_()) continue;
                if (rand.nextInt(8) == 0) {
                    List list = worldIn.m_46857_(blockpos1).m_47536_().m_47815_();
                    if (list.isEmpty()) continue;
                    placedfeature = (PlacedFeature)((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).m_65397_()).f_191304_().get();
                } else {
                    placedfeature = VegetationPlacements.f_195459_;
                }
                placedfeature.m_191782_((WorldGenLevel)worldIn, worldIn.m_7726_().m_8481_(), rand, blockpos1);
            }
        }
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (!GrassBlockSlab.isSnowyConditions(state, (LevelReader)worldIn, pos)) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            worldIn.m_46597_(pos, (BlockState)((BlockState)((Block)SlabInit.dirt_slab.get()).m_49966_().m_61124_((Property)f_56353_, (Comparable)((SlabType)state.m_61143_((Property)f_56353_)))).m_61124_((Property)f_56354_, (Comparable)((Boolean)state.m_61143_((Property)f_56354_))));
        } else if (worldIn.m_46803_(pos.m_7494_()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.m_142082_(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                BlockState blockstate = worldIn.m_8055_(blockpos);
                if (!GrassBlockSlab.isSnowyAndNotUnderwater(blockstate, (LevelReader)worldIn, blockpos)) continue;
                if (blockstate.m_60713_(Blocks.f_50493_)) {
                    worldIn.m_46597_(blockpos, (BlockState)Blocks.f_50440_.m_49966_().m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(worldIn.m_8055_(blockpos.m_7494_()).m_60713_(Blocks.f_50125_))));
                    continue;
                }
                if (blockstate.m_60713_((Block)StairsInit.dirt_stairs.get())) {
                    worldIn.m_46597_(blockpos, (BlockState)((BlockState)((BlockState)((BlockState)((Block)StairsInit.grass_block_stairs.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)blockstate.m_61143_((Property)BlockStateProperties.f_61374_)))).m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)((Half)blockstate.m_61143_((Property)BlockStateProperties.f_61402_)))).m_61124_((Property)BlockStateProperties.f_61398_, (Comparable)((StairsShape)blockstate.m_61143_((Property)BlockStateProperties.f_61398_)))).m_61124_((Property)f_56354_, (Comparable)((Boolean)blockstate.m_61143_((Property)f_56354_))));
                    continue;
                }
                if (blockstate.m_60713_((Block)SlabInit.dirt_slab.get())) {
                    worldIn.m_46597_(blockpos, (BlockState)((BlockState)((Block)SlabInit.grass_block_slab.get()).m_49966_().m_61124_((Property)f_56353_, (Comparable)((SlabType)blockstate.m_61143_((Property)f_56353_)))).m_61124_((Property)f_56354_, (Comparable)((Boolean)blockstate.m_61143_((Property)f_56354_))));
                    continue;
                }
                if (blockstate.m_60713_((Block)FenceInit.dirt_fence.get())) {
                    worldIn.m_46597_(blockpos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)FenceInit.grass_block_fence.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)((Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61368_)))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)((Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61369_)))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)((Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61370_)))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)((Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61371_)))).m_61124_((Property)f_56354_, (Comparable)((Boolean)blockstate.m_61143_((Property)f_56354_))));
                    continue;
                }
                if (blockstate.m_60713_((Block)WallInit.dirt_wall.get())) {
                    worldIn.m_46597_(blockpos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)WallInit.grass_block_wall.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)((Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61366_)))).m_61124_((Property)BlockStateProperties.f_61379_, (Comparable)((WallSide)blockstate.m_61143_((Property)BlockStateProperties.f_61379_)))).m_61124_((Property)BlockStateProperties.f_61378_, (Comparable)((WallSide)blockstate.m_61143_((Property)BlockStateProperties.f_61378_)))).m_61124_((Property)BlockStateProperties.f_61380_, (Comparable)((WallSide)blockstate.m_61143_((Property)BlockStateProperties.f_61380_)))).m_61124_((Property)BlockStateProperties.f_61381_, (Comparable)((WallSide)blockstate.m_61143_((Property)BlockStateProperties.f_61381_)))).m_61124_((Property)f_56354_, (Comparable)((Boolean)blockstate.m_61143_((Property)f_56354_))));
                    continue;
                }
                if (!blockstate.m_60713_((Block)TrapdoorInit.dirt_trapdoor.get())) continue;
                worldIn.m_46597_(blockpos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)TrapdoorInit.grass_block_trapdoor.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)blockstate.m_61143_((Property)BlockStateProperties.f_61374_)))).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)((Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61446_)))).m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)((Half)blockstate.m_61143_((Property)BlockStateProperties.f_61402_)))).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)((Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61448_)))).m_61124_((Property)f_56354_, (Comparable)((Boolean)blockstate.m_61143_((Property)f_56354_))));
            }
        }
    }
}

