/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.stairs;

import com.ketheroth.vanillaextension.stairs.FallingStairs;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcretePowderStairs
extends FallingStairs
implements SimpleWaterloggedBlock {
    public ConcretePowderStairs(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean shouldSolidify(BlockGetter reader, BlockPos pos, BlockState state) {
        return ConcretePowderStairs.canSolidify(state) || ConcretePowderStairs.touchesLiquid(reader, pos);
    }

    private static boolean touchesLiquid(BlockGetter reader, BlockPos pos) {
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutable = pos.m_122032_();
        for (Direction direction : Direction.values()) {
            BlockState blockstate = reader.m_8055_((BlockPos)blockpos$mutable);
            if (direction == Direction.DOWN && !ConcretePowderStairs.canSolidify(blockstate)) continue;
            blockpos$mutable.m_122159_((Vec3i)pos, direction);
            blockstate = reader.m_8055_((BlockPos)blockpos$mutable);
            if (!ConcretePowderStairs.canSolidify(blockstate) || blockstate.m_60783_(reader, pos, direction.m_122424_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean canSolidify(BlockState state) {
        return state.m_60819_().m_76153_((Tag)FluidTags.f_13131_);
    }

    private BlockState getSolidifiedState() {
        String[] part = this.getRegistryName().m_135815_().split("_powder");
        String name = part[0] + part[1];
        return ((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135822_((String)("vanillaextension:" + name), (char)':'))).m_49966_();
    }

    @Override
    public void m_142216_(Level worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingBlock) {
        BlockState newState = ConcretePowderStairs.shouldSolidify((BlockGetter)worldIn, pos, hitState) ? (BlockState)((BlockState)this.getSolidifiedState().m_61124_((Property)FACING, (Comparable)((Direction)fallingState.m_61143_((Property)FACING)))).m_61124_((Property)HALF, (Comparable)((Half)fallingState.m_61143_((Property)HALF))) : fallingState;
        worldIn.m_46597_(pos, (BlockState)((BlockState)newState.m_61124_((Property)SHAPE, (Comparable)ConcretePowderStairs.getShapeProperty(fallingState, (BlockGetter)worldIn, pos))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.m_6425_(pos).m_76152_() == Fluids.f_76193_)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        Level iblockreader = context.m_43725_();
        BlockState defaultState = ConcretePowderStairs.shouldSolidify((BlockGetter)iblockreader, blockpos, iblockreader.m_8055_(blockpos)) ? this.getSolidifiedState() : this.m_49966_();
        BlockState blockstate = (BlockState)((BlockState)((BlockState)defaultState.m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? Half.BOTTOM : Half.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockstate.m_61124_((Property)SHAPE, (Comparable)ConcretePowderStairs.getShapeProperty(blockstate, (BlockGetter)context.m_43725_(), blockpos));
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState blockstate = ConcretePowderStairs.touchesLiquid((BlockGetter)worldIn, currentPos) ? (BlockState)((BlockState)((BlockState)this.getSolidifiedState().m_61124_((Property)FACING, (Comparable)((Direction)stateIn.m_61143_((Property)FACING)))).m_61124_((Property)HALF, (Comparable)((Half)stateIn.m_61143_((Property)HALF)))).m_61124_((Property)SHAPE, (Comparable)((StairsShape)stateIn.m_61143_((Property)SHAPE))) : stateIn;
        return super.m_7417_(blockstate, facing, facingState, worldIn, currentPos, facingPos);
    }
}

