/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.stairs;

import com.ketheroth.vanillaextension.init.StairsInit;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DirtPathStairs
extends StairBlock {
    protected static final VoxelShape AABB_SLAB_TOP = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape AABB_SLAB_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape NWD_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)7.0, (double)8.0);
    protected static final VoxelShape SWD_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)7.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)8.0, (double)15.0, (double)8.0);
    protected static final VoxelShape SWU_CORNER = Block.m_49796_((double)0.0, (double)7.0, (double)8.0, (double)8.0, (double)15.0, (double)16.0);
    protected static final VoxelShape NED_CORNER = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)8.0);
    protected static final VoxelShape SED_CORNER = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.m_49796_((double)8.0, (double)7.0, (double)0.0, (double)16.0, (double)15.0, (double)8.0);
    protected static final VoxelShape SEU_CORNER = Block.m_49796_((double)8.0, (double)7.0, (double)8.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape[] SLAB_TOP_SHAPES = DirtPathStairs.makeShapesCustom(AABB_SLAB_TOP, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = DirtPathStairs.makeShapesCustom(AABB_SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] PALETTE_SHAPE_MAP = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    public DirtPathStairs(Supplier<BlockState> state, BlockBehaviour.Properties properties) {
        super(state, properties);
    }

    private static VoxelShape[] makeShapesCustom(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(bits -> DirtPathStairs.combineShapes(bits, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.m_61143_((Property)f_56841_);
        BlockState blockstate = worldIn.m_8055_(pos.m_142300_(direction));
        if (DirtPathStairs.isBlockStairs(blockstate) && state.m_61143_((Property)f_56842_) == blockstate.m_61143_((Property)f_56842_) && (direction1 = (Direction)blockstate.m_61143_((Property)f_56841_)).m_122434_() != ((Direction)state.m_61143_((Property)f_56841_)).m_122434_() && DirtPathStairs.isDifferentStairs(state, worldIn, pos, direction1.m_122424_())) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.m_8055_(pos.m_142300_(direction.m_122424_()));
        if (DirtPathStairs.isBlockStairs(blockstate1) && state.m_61143_((Property)f_56842_) == blockstate1.m_61143_((Property)f_56842_) && (direction2 = (Direction)blockstate1.m_61143_((Property)f_56841_)).m_122434_() != ((Direction)state.m_61143_((Property)f_56841_)).m_122434_() && DirtPathStairs.isDifferentStairs(state, worldIn, pos, direction2)) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(BlockState state, BlockGetter worldIn, BlockPos pos, Direction face) {
        BlockState blockstate = worldIn.m_8055_(pos.m_142300_(face));
        return !DirtPathStairs.isBlockStairs(blockstate) || blockstate.m_61143_((Property)f_56841_) != state.m_61143_((Property)f_56841_) || blockstate.m_61143_((Property)f_56842_) != state.m_61143_((Property)f_56842_);
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.m_60734_() instanceof StairBlock;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState bs = !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((Block)StairsInit.dirt_stairs.get()).m_49966_() : this.m_49966_();
        Direction direction = context.m_43719_();
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState blockstate = (BlockState)((BlockState)((BlockState)bs.m_61124_((Property)f_56841_, (Comparable)context.m_8125_())).m_61124_((Property)f_56842_, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? Half.BOTTOM : Half.TOP))).m_61124_((Property)f_56844_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockstate.m_61124_((Property)f_56843_, (Comparable)DirtPathStairs.getShapeProperty(blockstate, (BlockGetter)context.m_43725_(), blockpos));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (!this.m_7898_(state, (LevelReader)worldIn, pos)) {
            worldIn.m_46597_(pos, DirtPathStairs.m_49897_((BlockState)state, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)StairsInit.dirt_stairs.get()).m_49966_().m_61124_((Property)f_56841_, (Comparable)((Direction)state.m_61143_((Property)f_56841_)))).m_61124_((Property)f_56842_, (Comparable)((Half)state.m_61143_((Property)f_56842_)))).m_61124_((Property)f_56844_, (Comparable)((Boolean)state.m_61143_((Property)f_56844_)))).m_61124_((Property)f_56843_, (Comparable)((StairsShape)state.m_61143_((Property)f_56843_)))), (Level)worldIn, (BlockPos)pos));
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.m_8055_(pos.m_7494_());
        return !blockstate.m_60767_().m_76333_() || blockstate.m_60734_() instanceof FenceGateBlock;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (state.m_61143_((Property)f_56842_) == Half.TOP ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[PALETTE_SHAPE_MAP[this.getPaletteId(state)]];
    }

    private int getPaletteId(BlockState state) {
        return ((StairsShape)state.m_61143_((Property)f_56843_)).ordinal() * 4 + ((Direction)state.m_61143_((Property)f_56841_)).m_122416_();
    }
}

