/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.stairs;

import com.ketheroth.vanillaextension.init.StairsInit;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FarmStairs
extends FarmBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape AABB_SLAB_TOP = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape AABB_SLAB_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWD_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SWD_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)15.0, (double)8.0);
    protected static final VoxelShape SWU_CORNER = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)15.0, (double)16.0);
    protected static final VoxelShape NED_CORNER = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SED_CORNER = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)8.0);
    protected static final VoxelShape SEU_CORNER = Block.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape[] SLAB_TOP_SHAPES = FarmStairs.makeShapes(AABB_SLAB_TOP, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = FarmStairs.makeShapes(AABB_SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    public FarmStairs(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> FarmStairs.combineShapes(p_199780_5_, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState blockstate = worldIn.m_8055_(pos.m_142300_(direction));
        if (StairBlock.m_56980_((BlockState)blockstate) && state.m_61143_(HALF) == blockstate.m_61143_(HALF) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && FarmStairs.isDifferentStairs(state, worldIn, pos, direction1.m_122424_())) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.m_8055_(pos.m_142300_(direction.m_122424_()));
        if (StairBlock.m_56980_((BlockState)blockstate1) && state.m_61143_(HALF) == blockstate1.m_61143_(HALF) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && FarmStairs.isDifferentStairs(state, worldIn, pos, direction2)) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(BlockState state, BlockGetter worldIn, BlockPos pos, Direction face) {
        BlockState blockstate = worldIn.m_8055_(pos.m_142300_(face));
        return !StairBlock.m_56980_((BlockState)blockstate) || blockstate.m_61143_((Property)FACING) != state.m_61143_((Property)FACING) || blockstate.m_61143_(HALF) != state.m_61143_(HALF);
    }

    public static void turnToDirtStairs(BlockState state, Level worldIn, BlockPos pos) {
        BlockState bs = (BlockState)((BlockState)((BlockState)((BlockState)((Block)StairsInit.dirt_stairs.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_(HALF, (Comparable)((Half)state.m_61143_(HALF)))).m_61124_(SHAPE, (Comparable)((StairsShape)state.m_61143_(SHAPE)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
        worldIn.m_46597_(pos, bs);
    }

    private static boolean hasWater(LevelReader worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-4, 0, -4), (BlockPos)pos.m_142082_(4, 1, 4))) {
            if (!worldIn.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13131_)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)worldIn, (BlockPos)pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (state.m_61143_(HALF) == Half.TOP ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(state)]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)state.m_61143_((Property)FACING)).m_122416_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState blockstate = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? Half.BOTTOM : Half.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((Block)StairsInit.dirt_stairs.get()).m_49966_() : (BlockState)blockstate.m_61124_(SHAPE, (Comparable)FarmStairs.getShapeProperty(blockstate, (BlockGetter)context.m_43725_(), blockpos));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return facing.m_122434_().m_122479_() ? (BlockState)stateIn.m_61124_(SHAPE, (Comparable)FarmStairs.getShapeProperty(stateIn, (BlockGetter)worldIn, currentPos)) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.m_61143_(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                return switch (stairsshape) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                return switch (stairsshape) {
                    default -> throw new IncompatibleClassChangeError();
                    case StairsShape.INNER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF, SHAPE, WATERLOGGED, f_53243_});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.m_142300_(facing));
        return PlantType.CROP.equals(type);
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        int i = (Integer)state.m_61143_((Property)f_53243_);
        if (!FarmStairs.hasWater((LevelReader)worldIn, pos) && !worldIn.m_46758_(pos.m_7494_())) {
            if (i > 0) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops((BlockGetter)worldIn, pos)) {
                FarmStairs.turnToDirtStairs(state, (Level)worldIn, pos);
            }
        } else if (i < 7) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    private boolean hasCrops(BlockGetter worldIn, BlockPos pos) {
        BlockState state = worldIn.m_8055_(pos.m_7494_());
        return state.m_60734_() instanceof IPlantable && this.canSustainPlant(state, worldIn, pos, Direction.UP, (IPlantable)state.m_60734_());
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.f_46443_ && ForgeHooks.onFarmlandTrample((Level)worldIn, (BlockPos)pos, (BlockState)Blocks.f_50493_.m_49966_(), (float)fallDistance, (Entity)entityIn)) {
            FarmStairs.turnToDirtStairs(worldIn.m_8055_(pos), worldIn, pos);
        }
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance);
    }
}

