/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.trapdoors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcretePowderTrapdoor
extends FallingBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape EAST_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_OPEN_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ConcretePowderTrapdoor(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.FALSE)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    private static boolean shouldSolidify(BlockGetter reader, BlockPos pos, BlockState state) {
        return ConcretePowderTrapdoor.causesSolidify(state) || ConcretePowderTrapdoor.isTouchingLiquid(reader, pos);
    }

    private static boolean isTouchingLiquid(BlockGetter reader, BlockPos pos) {
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutable = pos.m_122032_();
        for (Direction direction : Direction.values()) {
            BlockState blockstate = reader.m_8055_((BlockPos)blockpos$mutable);
            if (direction == Direction.DOWN && !ConcretePowderTrapdoor.causesSolidify(blockstate)) continue;
            blockpos$mutable.m_122159_((Vec3i)pos, direction);
            blockstate = reader.m_8055_((BlockPos)blockpos$mutable);
            if (!ConcretePowderTrapdoor.causesSolidify(blockstate) || blockstate.m_60783_(reader, pos, direction.m_122424_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean causesSolidify(BlockState state) {
        return state.m_60819_().m_76153_((Tag)FluidTags.f_13131_);
    }

    private BlockState getSolidifiedState() {
        String[] part = this.getRegistryName().m_135815_().split("_powder");
        String name = part[0] + part[1];
        return ((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135822_((String)("vanillaextension:" + name), (char)':'))).m_49966_();
    }

    public void m_142216_(Level worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingBlock) {
        if (ConcretePowderTrapdoor.shouldSolidify((BlockGetter)worldIn, pos, hitState)) {
            worldIn.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getSolidifiedState().m_61124_((Property)HORIZONTAL_FACING, (Comparable)((Direction)fallingState.m_61143_((Property)HORIZONTAL_FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)fallingState.m_61143_((Property)OPEN)))).m_61124_(HALF, (Comparable)((Half)fallingState.m_61143_(HALF)))).m_61124_((Property)POWERED, (Comparable)((Boolean)fallingState.m_61143_((Property)POWERED)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)fallingState.m_61143_((Property)WATERLOGGED))), 3);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return state.m_61143_(HALF) == Half.TOP ? TOP_AABB : BOTTOM_AABB;
        }
        return switch ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)) {
            default -> NORTH_OPEN_AABB;
            case Direction.SOUTH -> SOUTH_OPEN_AABB;
            case Direction.WEST -> WEST_OPEN_AABB;
            case Direction.EAST -> EAST_OPEN_AABB;
        };
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.m_61143_((Property)OPEN);
            case PathComputationType.WATER -> (Boolean)state.m_61143_((Property)WATERLOGGED);
        };
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (this.f_60442_ == Material.f_76279_) {
            return InteractionResult.PASS;
        }
        state = (BlockState)state.m_61122_((Property)OPEN);
        worldIn.m_7731_(pos, state, 2);
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        this.playSound(player, worldIn, pos, (Boolean)state.m_61143_((Property)OPEN));
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    protected void playSound(@Nullable Player player, Level worldIn, BlockPos pos, boolean p_185731_4_) {
        if (p_185731_4_) {
            int i = this.f_60442_ == Material.f_76279_ ? 1037 : 1007;
            worldIn.m_5898_(player, i, pos, 0);
        } else {
            int j = this.f_60442_ == Material.f_76279_ ? 1036 : 1013;
            worldIn.m_5898_(player, j, pos, 0);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.f_46443_ && (flag = worldIn.m_46753_(pos)) != (Boolean)state.m_61143_((Property)POWERED)) {
            if ((Boolean)state.m_61143_((Property)OPEN) != flag) {
                state = (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag));
                this.playSound(null, worldIn, pos, flag);
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                worldIn.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, OPEN, HALF, POWERED, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        BlockState down;
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() && (down = world.m_8055_(pos.m_7495_())).m_60734_() == Blocks.f_50155_) {
            return down.m_61143_((Property)LadderBlock.f_54337_) == state.m_61143_((Property)HORIZONTAL_FACING);
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate0;
        BlockPos blockpos;
        Level iblockreader = context.m_43725_();
        BlockState blockstate = ConcretePowderTrapdoor.shouldSolidify((BlockGetter)iblockreader, blockpos = context.m_8083_(), blockstate0 = iblockreader.m_8055_(blockpos)) ? this.getSolidifiedState() : this.m_49966_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        Direction direction = context.m_43719_();
        blockstate = !context.m_7058_() && direction.m_122434_().m_122479_() ? (BlockState)((BlockState)blockstate.m_61124_((Property)HORIZONTAL_FACING, (Comparable)direction)).m_61124_(HALF, (Comparable)(context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5 ? Half.TOP : Half.BOTTOM)) : (BlockState)((BlockState)blockstate.m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)(direction == Direction.UP ? Half.BOTTOM : Half.TOP));
        if (context.m_43725_().m_46753_(context.m_8083_())) {
            blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)OPEN, (Comparable)Boolean.TRUE)).m_61124_((Property)POWERED, (Comparable)Boolean.TRUE);
        }
        return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return ConcretePowderTrapdoor.isTouchingLiquid((BlockGetter)worldIn, currentPos) ? (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getSolidifiedState().m_61124_((Property)HORIZONTAL_FACING, (Comparable)((Direction)stateIn.m_61143_((Property)HORIZONTAL_FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)stateIn.m_61143_((Property)OPEN)))).m_61124_(HALF, (Comparable)((Half)stateIn.m_61143_(HALF)))).m_61124_((Property)POWERED, (Comparable)((Boolean)stateIn.m_61143_((Property)POWERED)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)stateIn.m_61143_((Property)WATERLOGGED))) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

