/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.trapdoors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FallingTrapdoor
extends FallingBlock {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape EAST_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_OPEN_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public FallingTrapdoor(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.FALSE)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return state.m_61143_(HALF) == Half.TOP ? TOP_AABB : BOTTOM_AABB;
        }
        return switch ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)) {
            default -> NORTH_OPEN_AABB;
            case Direction.SOUTH -> SOUTH_OPEN_AABB;
            case Direction.WEST -> WEST_OPEN_AABB;
            case Direction.EAST -> EAST_OPEN_AABB;
        };
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.m_61143_((Property)OPEN);
            case PathComputationType.WATER -> (Boolean)state.m_61143_((Property)WATERLOGGED);
        };
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (this.f_60442_ == Material.f_76279_) {
            return InteractionResult.PASS;
        }
        state = (BlockState)state.m_61122_((Property)OPEN);
        worldIn.m_7731_(pos, state, 2);
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        this.playSound(player, worldIn, pos, (Boolean)state.m_61143_((Property)OPEN));
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    protected void playSound(@Nullable Player player, Level worldIn, BlockPos pos, boolean p_185731_4_) {
        if (p_185731_4_) {
            int i = this.f_60442_ == Material.f_76279_ ? 1037 : 1007;
            worldIn.m_5898_(player, i, pos, 0);
        } else {
            int j = this.f_60442_ == Material.f_76279_ ? 1036 : 1013;
            worldIn.m_5898_(player, j, pos, 0);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.f_46443_ && (flag = worldIn.m_46753_(pos)) != (Boolean)state.m_61143_((Property)POWERED)) {
            if ((Boolean)state.m_61143_((Property)OPEN) != flag) {
                state = (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag));
                this.playSound(null, worldIn, pos, flag);
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                worldIn.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        Direction direction = context.m_43719_();
        blockstate = !context.m_7058_() && direction.m_122434_().m_122479_() ? (BlockState)((BlockState)blockstate.m_61124_((Property)HORIZONTAL_FACING, (Comparable)direction)).m_61124_(HALF, (Comparable)(context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5 ? Half.TOP : Half.BOTTOM)) : (BlockState)((BlockState)blockstate.m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)(direction == Direction.UP ? Half.BOTTOM : Half.TOP));
        if (context.m_43725_().m_46753_(context.m_8083_())) {
            blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)OPEN, (Comparable)Boolean.TRUE)).m_61124_((Property)POWERED, (Comparable)Boolean.TRUE);
        }
        return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, OPEN, HALF, POWERED, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        worldIn.m_186460_(currentPos, (Block)this, this.m_7198_());
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

