/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.walls;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcretePowderWall
extends FallingBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final EnumProperty<WallSide> WALL_HEIGHT_EAST = BlockStateProperties.f_61378_;
    public static final EnumProperty<WallSide> WALL_HEIGHT_NORTH = BlockStateProperties.f_61379_;
    public static final EnumProperty<WallSide> WALL_HEIGHT_SOUTH = BlockStateProperties.f_61380_;
    public static final EnumProperty<WallSide> WALL_HEIGHT_WEST = BlockStateProperties.f_61381_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape CENTER_POLE_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape WALL_CONNECTION_NORTH_SIDE_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape WALL_CONNECTION_SOUTH_SIDE_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WALL_CONNECTION_WEST_SIDE_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape WALL_CONNECTION_EAST_SIDE_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    private final Map<BlockState, VoxelShape> stateToShapeMap;
    private final Map<BlockState, VoxelShape> stateToCollisionShapeMap;

    public ConcretePowderWall(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.TRUE)).m_61124_(WALL_HEIGHT_NORTH, (Comparable)WallSide.NONE)).m_61124_(WALL_HEIGHT_EAST, (Comparable)WallSide.NONE)).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)WallSide.NONE)).m_61124_(WALL_HEIGHT_WEST, (Comparable)WallSide.NONE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.stateToShapeMap = this.makeShapes(4.0f, 3.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.stateToCollisionShapeMap = this.makeShapes(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static VoxelShape getHeightAlteredShape(VoxelShape baseShape, WallSide height, VoxelShape lowShape, VoxelShape tallShape) {
        if (height == WallSide.TALL) {
            return Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)tallShape);
        }
        return height == WallSide.LOW ? Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)lowShape) : baseShape;
    }

    private static boolean hasHeightForProperty(BlockState state, Property<WallSide> heightProperty) {
        return state.m_61143_(heightProperty) != WallSide.NONE;
    }

    private static boolean compareShapes(VoxelShape shape1, VoxelShape shape2) {
        return !Shapes.m_83157_((VoxelShape)shape2, (VoxelShape)shape1, (BooleanOp)BooleanOp.f_82685_);
    }

    private static boolean shouldSolidify(BlockGetter reader, BlockPos pos, BlockState state) {
        return ConcretePowderWall.causesSolidify(state) || ConcretePowderWall.isTouchingLiquid(reader, pos);
    }

    private static boolean isTouchingLiquid(BlockGetter reader, BlockPos pos) {
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutable = pos.m_122032_();
        for (Direction direction : Direction.values()) {
            BlockState blockstate = reader.m_8055_((BlockPos)blockpos$mutable);
            if (direction == Direction.DOWN && !ConcretePowderWall.causesSolidify(blockstate)) continue;
            blockpos$mutable.m_122159_((Vec3i)pos, direction);
            blockstate = reader.m_8055_((BlockPos)blockpos$mutable);
            if (!ConcretePowderWall.causesSolidify(blockstate) || blockstate.m_60783_(reader, pos, direction.m_122424_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean causesSolidify(BlockState state) {
        return state.m_60819_().m_76153_((Tag)FluidTags.f_13131_);
    }

    private BlockState getSolidifiedState() {
        String[] part = this.getRegistryName().m_135815_().split("_powder");
        String name = part[0] + part[1];
        return ((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135822_((String)("vanillaextension:" + name), (char)':'))).m_49966_();
    }

    private Map<BlockState, VoxelShape> makeShapes(float p_235624_1_, float p_235624_2_, float p_235624_3_, float p_235624_4_, float p_235624_5_, float p_235624_6_) {
        float f = 8.0f - p_235624_1_;
        float f1 = 8.0f + p_235624_1_;
        float f2 = 8.0f - p_235624_2_;
        float f3 = 8.0f + p_235624_2_;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)p_235624_3_, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)0.0, (double)f3, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)16.0, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape5 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)0.0, (double)f3, (double)p_235624_6_, (double)f3);
        VoxelShape voxelshape6 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_6_, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_6_, (double)f3);
        VoxelShape voxelshape8 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)16.0, (double)p_235624_6_, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean obool : UP.m_6908_()) {
            for (WallSide wallheight : WALL_HEIGHT_EAST.m_6908_()) {
                for (WallSide wallheight1 : WALL_HEIGHT_NORTH.m_6908_()) {
                    for (WallSide wallheight2 : WALL_HEIGHT_WEST.m_6908_()) {
                        for (WallSide wallheight3 : WALL_HEIGHT_SOUTH.m_6908_()) {
                            VoxelShape voxelshape9 = Shapes.m_83040_();
                            voxelshape9 = ConcretePowderWall.getHeightAlteredShape(voxelshape9, wallheight, voxelshape4, voxelshape8);
                            voxelshape9 = ConcretePowderWall.getHeightAlteredShape(voxelshape9, wallheight2, voxelshape3, voxelshape7);
                            voxelshape9 = ConcretePowderWall.getHeightAlteredShape(voxelshape9, wallheight1, voxelshape1, voxelshape5);
                            voxelshape9 = ConcretePowderWall.getHeightAlteredShape(voxelshape9, wallheight3, voxelshape2, voxelshape6);
                            if (obool.booleanValue()) {
                                voxelshape9 = Shapes.m_83110_((VoxelShape)voxelshape9, (VoxelShape)voxelshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)obool)).m_61124_(WALL_HEIGHT_EAST, (Comparable)wallheight)).m_61124_(WALL_HEIGHT_WEST, (Comparable)wallheight2)).m_61124_(WALL_HEIGHT_NORTH, (Comparable)wallheight1)).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)wallheight3);
                            builder.put((Object)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)), (Object)voxelshape9);
                            builder.put((Object)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE)), (Object)voxelshape9);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.stateToShapeMap.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.stateToCollisionShapeMap.get(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    private boolean shouldConnect(BlockState state, boolean sideSolid, Direction direction) {
        Block block = state.m_60734_();
        boolean flag = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return state.m_60620_((Tag)BlockTags.f_13032_) || !ConcretePowderWall.m_152463_((BlockState)state) && sideSolid || block instanceof IronBarsBlock || flag;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iworldreader = context.m_43725_();
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockState blockstate = iblockreader.m_8055_(blockpos);
        BlockPos blockpos1 = blockpos.m_142127_();
        BlockPos blockpos2 = blockpos.m_142126_();
        BlockPos blockpos3 = blockpos.m_142128_();
        BlockPos blockpos4 = blockpos.m_142125_();
        BlockPos blockpos5 = blockpos.m_7494_();
        BlockState blockstate1 = iworldreader.m_8055_(blockpos1);
        BlockState blockstate2 = iworldreader.m_8055_(blockpos2);
        BlockState blockstate3 = iworldreader.m_8055_(blockpos3);
        BlockState blockstate4 = iworldreader.m_8055_(blockpos4);
        BlockState blockstate5 = iworldreader.m_8055_(blockpos5);
        boolean flag = this.shouldConnect(blockstate1, blockstate1.m_60783_((BlockGetter)iworldreader, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.shouldConnect(blockstate2, blockstate2.m_60783_((BlockGetter)iworldreader, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.shouldConnect(blockstate3, blockstate3.m_60783_((BlockGetter)iworldreader, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.shouldConnect(blockstate4, blockstate4.m_60783_((BlockGetter)iworldreader, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate6 = ConcretePowderWall.shouldSolidify((BlockGetter)iblockreader, blockpos, blockstate) ? (BlockState)this.getSolidifiedState().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_)) : (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return this.updateShape((LevelReader)iworldreader, blockstate6, blockpos5, blockstate5, flag, flag1, flag2, flag3);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState blockstate;
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        BlockState blockState = blockstate = ConcretePowderWall.isTouchingLiquid((BlockGetter)worldIn, currentPos) ? (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getSolidifiedState().m_61124_((Property)UP, (Comparable)((Boolean)stateIn.m_61143_((Property)UP)))).m_61124_(WALL_HEIGHT_NORTH, (Comparable)((WallSide)stateIn.m_61143_(WALL_HEIGHT_NORTH)))).m_61124_(WALL_HEIGHT_EAST, (Comparable)((WallSide)stateIn.m_61143_(WALL_HEIGHT_EAST)))).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)((WallSide)stateIn.m_61143_(WALL_HEIGHT_SOUTH)))).m_61124_(WALL_HEIGHT_WEST, (Comparable)((WallSide)stateIn.m_61143_(WALL_HEIGHT_WEST)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)stateIn.m_61143_((Property)WATERLOGGED))) : stateIn;
        if (facing == Direction.DOWN) {
            return super.m_7417_(blockstate, facing, facingState, worldIn, currentPos, facingPos);
        }
        return facing == Direction.UP ? this.topUpdate((LevelReader)worldIn, blockstate, facingPos, facingState) : this.sideUpdate((LevelReader)worldIn, currentPos, blockstate, facingPos, facingState, facing);
    }

    private BlockState topUpdate(LevelReader reader, BlockState state1, BlockPos pos, BlockState state2) {
        boolean flag = ConcretePowderWall.hasHeightForProperty(state1, WALL_HEIGHT_NORTH);
        boolean flag1 = ConcretePowderWall.hasHeightForProperty(state1, WALL_HEIGHT_EAST);
        boolean flag2 = ConcretePowderWall.hasHeightForProperty(state1, WALL_HEIGHT_SOUTH);
        boolean flag3 = ConcretePowderWall.hasHeightForProperty(state1, WALL_HEIGHT_WEST);
        return this.updateShape(reader, state1, pos, state2, flag, flag1, flag2, flag3);
    }

    private BlockState sideUpdate(LevelReader reader, BlockPos p_235627_2_, BlockState p_235627_3_, BlockPos p_235627_4_, BlockState p_235627_5_, Direction directionIn) {
        Direction direction = directionIn.m_122424_();
        boolean flag = directionIn == Direction.NORTH ? this.shouldConnect(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)reader, p_235627_4_, direction), direction) : ConcretePowderWall.hasHeightForProperty(p_235627_3_, WALL_HEIGHT_NORTH);
        boolean flag1 = directionIn == Direction.EAST ? this.shouldConnect(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)reader, p_235627_4_, direction), direction) : ConcretePowderWall.hasHeightForProperty(p_235627_3_, WALL_HEIGHT_EAST);
        boolean flag2 = directionIn == Direction.SOUTH ? this.shouldConnect(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)reader, p_235627_4_, direction), direction) : ConcretePowderWall.hasHeightForProperty(p_235627_3_, WALL_HEIGHT_SOUTH);
        boolean flag3 = directionIn == Direction.WEST ? this.shouldConnect(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)reader, p_235627_4_, direction), direction) : ConcretePowderWall.hasHeightForProperty(p_235627_3_, WALL_HEIGHT_WEST);
        BlockPos blockpos = p_235627_2_.m_7494_();
        BlockState blockstate = reader.m_8055_(blockpos);
        return this.updateShape(reader, p_235627_3_, blockpos, blockstate, flag, flag1, flag2, flag3);
    }

    private BlockState updateShape(LevelReader reader, BlockState state, BlockPos pos, BlockState collisionState, boolean connectedSouth, boolean connectedWest, boolean connectedNorth, boolean connectedEast) {
        VoxelShape voxelshape = collisionState.m_60816_((BlockGetter)reader, pos).m_83263_(Direction.DOWN);
        BlockState blockstate = this.updateSides(state, connectedSouth, connectedWest, connectedNorth, connectedEast, voxelshape);
        return (BlockState)blockstate.m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.shouldRaisePost(blockstate, collisionState, voxelshape)));
    }

    private boolean shouldRaisePost(BlockState state, BlockState state1, VoxelShape shape) {
        boolean flag6;
        boolean flag5;
        boolean flag;
        boolean bl = flag = state1.m_60734_() instanceof WallBlock && (Boolean)state1.m_61143_((Property)UP) != false;
        if (flag) {
            return true;
        }
        WallSide sideNorth = (WallSide)state.m_61143_(WALL_HEIGHT_NORTH);
        WallSide sideSouth = (WallSide)state.m_61143_(WALL_HEIGHT_SOUTH);
        WallSide sideEast = (WallSide)state.m_61143_(WALL_HEIGHT_EAST);
        WallSide sideWest = (WallSide)state.m_61143_(WALL_HEIGHT_WEST);
        boolean noSouthSide = sideSouth == WallSide.NONE;
        boolean noWestSide = sideWest == WallSide.NONE;
        boolean noEastSide = sideEast == WallSide.NONE;
        boolean noNorthSide = sideNorth == WallSide.NONE;
        boolean bl2 = flag5 = noNorthSide && noSouthSide && noWestSide && noEastSide || noNorthSide != noSouthSide || noWestSide != noEastSide;
        if (flag5) {
            return true;
        }
        boolean bl3 = flag6 = sideNorth == WallSide.TALL && sideSouth == WallSide.TALL || sideEast == WallSide.TALL && sideWest == WallSide.TALL;
        if (flag6) {
            return false;
        }
        return state1.m_60620_((Tag)BlockTags.f_13081_) || ConcretePowderWall.compareShapes(shape, CENTER_POLE_SHAPE);
    }

    private BlockState updateSides(BlockState state, boolean connectedSouth, boolean connectedWest, boolean connectedNorth, boolean connectedEast, VoxelShape shape) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(WALL_HEIGHT_NORTH, (Comparable)this.makeWallState(connectedSouth, shape, WALL_CONNECTION_NORTH_SIDE_SHAPE))).m_61124_(WALL_HEIGHT_EAST, (Comparable)this.makeWallState(connectedWest, shape, WALL_CONNECTION_EAST_SIDE_SHAPE))).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)this.makeWallState(connectedNorth, shape, WALL_CONNECTION_SOUTH_SIDE_SHAPE))).m_61124_(WALL_HEIGHT_WEST, (Comparable)this.makeWallState(connectedEast, shape, WALL_CONNECTION_WEST_SIDE_SHAPE));
    }

    private WallSide makeWallState(boolean p_235633_1_, VoxelShape p_235633_2_, VoxelShape p_235633_3_) {
        if (p_235633_1_) {
            return ConcretePowderWall.compareShapes(p_235633_2_, p_235633_3_) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, WALL_HEIGHT_NORTH, WALL_HEIGHT_EAST, WALL_HEIGHT_WEST, WALL_HEIGHT_SOUTH, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(WALL_HEIGHT_NORTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_SOUTH)))).m_61124_(WALL_HEIGHT_EAST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_WEST)))).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_NORTH)))).m_61124_(WALL_HEIGHT_WEST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(WALL_HEIGHT_NORTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_EAST)))).m_61124_(WALL_HEIGHT_EAST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_SOUTH)))).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_WEST)))).m_61124_(WALL_HEIGHT_WEST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(WALL_HEIGHT_NORTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_WEST)))).m_61124_(WALL_HEIGHT_EAST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_NORTH)))).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_EAST)))).m_61124_(WALL_HEIGHT_WEST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_SOUTH)));
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return switch (mirrorIn) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_(WALL_HEIGHT_NORTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_SOUTH)))).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_(WALL_HEIGHT_EAST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_WEST)))).m_61124_(WALL_HEIGHT_WEST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_EAST)));
            default -> super.m_6943_(state, mirrorIn);
        };
    }

    public void m_142216_(Level worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingBlock) {
        FluidState fluidstate = worldIn.m_6425_(pos);
        BlockPos blockpos1 = pos.m_142127_();
        BlockPos blockpos2 = pos.m_142126_();
        BlockPos blockpos3 = pos.m_142128_();
        BlockPos blockpos4 = pos.m_142125_();
        BlockPos blockpos5 = pos.m_7494_();
        BlockState blockstate = worldIn.m_8055_(blockpos1);
        BlockState blockstate1 = worldIn.m_8055_(blockpos2);
        BlockState blockstate2 = worldIn.m_8055_(blockpos3);
        BlockState blockstate3 = worldIn.m_8055_(blockpos4);
        BlockState blockstate4 = worldIn.m_8055_(blockpos5);
        boolean flag = this.shouldConnect(blockstate, blockstate.m_60783_((BlockGetter)worldIn, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.shouldConnect(blockstate1, blockstate1.m_60783_((BlockGetter)worldIn, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.shouldConnect(blockstate2, blockstate2.m_60783_((BlockGetter)worldIn, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.shouldConnect(blockstate3, blockstate3.m_60783_((BlockGetter)worldIn, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = ConcretePowderWall.shouldSolidify((BlockGetter)worldIn, pos, hitState) ? this.getSolidifiedState() : this.m_49966_();
        blockstate5.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        BlockState bs = this.updateShape((LevelReader)worldIn, blockstate5, blockpos5, blockstate4, flag, flag1, flag2, flag3);
        worldIn.m_46597_(pos, bs);
    }
}

