/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.walls;

import com.google.common.collect.ImmutableMap;
import com.ketheroth.vanillaextension.init.WallInit;
import java.util.Map;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DirtPathWall
extends WallBlock {
    private final Map<BlockState, VoxelShape> stateToShapeMap = this.makeShapes(4.0f, 3.0f, 15.0f, 0.0f, 13.0f, 16.0f);
    private final Map<BlockState, VoxelShape> stateToCollisionShapeMap = this.makeShapes(4.0f, 3.0f, 23.0f, 0.0f, 23.0f, 23.0f);
    private static final VoxelShape CENTER_POLE_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0);
    private static final VoxelShape WALL_CONNECTION_NORTH_SIDE_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)15.0, (double)9.0);
    private static final VoxelShape WALL_CONNECTION_SOUTH_SIDE_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)15.0, (double)16.0);
    private static final VoxelShape WALL_CONNECTION_WEST_SIDE_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0);
    private static final VoxelShape WALL_CONNECTION_EAST_SIDE_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0);

    public DirtPathWall(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private Map<BlockState, VoxelShape> makeShapes(float p_235624_1_, float p_235624_2_, float p_235624_3_, float p_235624_4_, float p_235624_5_, float p_235624_6_) {
        float f = 8.0f - p_235624_1_;
        float f1 = 8.0f + p_235624_1_;
        float f2 = 8.0f - p_235624_2_;
        float f3 = 8.0f + p_235624_2_;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)p_235624_3_, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)0.0, (double)f3, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)16.0, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape5 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)0.0, (double)f3, (double)p_235624_6_, (double)f3);
        VoxelShape voxelshape6 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_6_, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_6_, (double)f3);
        VoxelShape voxelshape8 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)16.0, (double)p_235624_6_, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean obool : f_57949_.m_6908_()) {
            for (WallSide wallheight : f_57950_.m_6908_()) {
                for (WallSide wallheight1 : f_57951_.m_6908_()) {
                    for (WallSide wallheight2 : f_57953_.m_6908_()) {
                        for (WallSide wallheight3 : f_57952_.m_6908_()) {
                            VoxelShape voxelshape9 = Shapes.m_83040_();
                            voxelshape9 = DirtPathWall.getHeightAlteredShape(voxelshape9, wallheight, voxelshape4, voxelshape8);
                            voxelshape9 = DirtPathWall.getHeightAlteredShape(voxelshape9, wallheight2, voxelshape3, voxelshape7);
                            voxelshape9 = DirtPathWall.getHeightAlteredShape(voxelshape9, wallheight1, voxelshape1, voxelshape5);
                            voxelshape9 = DirtPathWall.getHeightAlteredShape(voxelshape9, wallheight3, voxelshape2, voxelshape6);
                            if (obool.booleanValue()) {
                                voxelshape9 = Shapes.m_83110_((VoxelShape)voxelshape9, (VoxelShape)voxelshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_57949_, (Comparable)obool)).m_61124_((Property)f_57950_, (Comparable)wallheight)).m_61124_((Property)f_57953_, (Comparable)wallheight2)).m_61124_((Property)f_57951_, (Comparable)wallheight1)).m_61124_((Property)f_57952_, (Comparable)wallheight3);
                            builder.put((Object)((BlockState)blockstate.m_61124_((Property)f_57954_, (Comparable)Boolean.FALSE)), (Object)voxelshape9);
                            builder.put((Object)((BlockState)blockstate.m_61124_((Property)f_57954_, (Comparable)Boolean.TRUE)), (Object)voxelshape9);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    private static VoxelShape getHeightAlteredShape(VoxelShape baseShape, WallSide height, VoxelShape lowShape, VoxelShape tallShape) {
        if (height == WallSide.TALL) {
            return Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)tallShape);
        }
        return height == WallSide.LOW ? Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)lowShape) : baseShape;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iworldreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos blockpos1 = blockpos.m_142127_();
        BlockPos blockpos2 = blockpos.m_142126_();
        BlockPos blockpos3 = blockpos.m_142128_();
        BlockPos blockpos4 = blockpos.m_142125_();
        BlockPos blockpos5 = blockpos.m_7494_();
        BlockState blockstate = iworldreader.m_8055_(blockpos1);
        BlockState blockstate1 = iworldreader.m_8055_(blockpos2);
        BlockState blockstate2 = iworldreader.m_8055_(blockpos3);
        BlockState blockstate3 = iworldreader.m_8055_(blockpos4);
        BlockState blockstate4 = iworldreader.m_8055_(blockpos5);
        boolean flag = this.shouldConnect(blockstate, blockstate.m_60783_((BlockGetter)iworldreader, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.shouldConnect(blockstate1, blockstate1.m_60783_((BlockGetter)iworldreader, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.shouldConnect(blockstate2, blockstate2.m_60783_((BlockGetter)iworldreader, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.shouldConnect(blockstate3, blockstate3.m_60783_((BlockGetter)iworldreader, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = (BlockState)(!this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((Block)WallInit.dirt_wall.get()).m_49966_() : this.m_49966_()).m_61124_((Property)f_57954_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return this.updateShape((LevelReader)iworldreader, blockstate5, blockpos5, blockstate4, flag, flag1, flag2, flag3);
    }

    private boolean shouldConnect(BlockState state, boolean sideSolid, Direction direction) {
        Block block = state.m_60734_();
        boolean flag = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return state.m_60620_((Tag)BlockTags.f_13032_) || !DirtPathWall.m_152463_((BlockState)state) && sideSolid || block instanceof IronBarsBlock || flag;
    }

    private BlockState updateShape(LevelReader reader, BlockState state, BlockPos pos, BlockState collisionState, boolean connectedSouth, boolean connectedWest, boolean connectedNorth, boolean connectedEast) {
        VoxelShape voxelshape = collisionState.m_60816_((BlockGetter)reader, pos).m_83263_(Direction.DOWN);
        BlockState blockstate = this.updateSides(state, connectedSouth, connectedWest, connectedNorth, connectedEast, voxelshape);
        return (BlockState)blockstate.m_61124_((Property)f_57949_, (Comparable)Boolean.valueOf(this.shouldRaisePost(blockstate, collisionState, voxelshape)));
    }

    private boolean shouldRaisePost(BlockState p_235628_1_, BlockState p_235628_2_, VoxelShape shape) {
        boolean flag6;
        boolean flag5;
        boolean flag;
        boolean bl = flag = p_235628_2_.m_60734_() instanceof WallBlock && (Boolean)p_235628_2_.m_61143_((Property)f_57949_) != false;
        if (flag) {
            return true;
        }
        WallSide wallheight = (WallSide)p_235628_1_.m_61143_((Property)f_57951_);
        WallSide wallheight1 = (WallSide)p_235628_1_.m_61143_((Property)f_57952_);
        WallSide wallheight2 = (WallSide)p_235628_1_.m_61143_((Property)f_57950_);
        WallSide wallheight3 = (WallSide)p_235628_1_.m_61143_((Property)f_57953_);
        boolean flag1 = wallheight1 == WallSide.NONE;
        boolean flag2 = wallheight3 == WallSide.NONE;
        boolean flag3 = wallheight2 == WallSide.NONE;
        boolean flag4 = wallheight == WallSide.NONE;
        boolean bl2 = flag5 = flag4 && flag1 && flag2 && flag3 || flag4 != flag1 || flag2 != flag3;
        if (flag5) {
            return true;
        }
        boolean bl3 = flag6 = wallheight == WallSide.TALL && wallheight1 == WallSide.TALL || wallheight2 == WallSide.TALL && wallheight3 == WallSide.TALL;
        if (flag6) {
            return false;
        }
        return p_235628_2_.m_60620_((Tag)BlockTags.f_13081_) || DirtPathWall.compareShapes(shape, CENTER_POLE_SHAPE);
    }

    private BlockState updateSides(BlockState state, boolean connectedSouth, boolean connectedWest, boolean connectedNorth, boolean connectedEast, VoxelShape shape) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_57951_, (Comparable)this.makeWallState(connectedSouth, shape, WALL_CONNECTION_NORTH_SIDE_SHAPE))).m_61124_((Property)f_57950_, (Comparable)this.makeWallState(connectedWest, shape, WALL_CONNECTION_EAST_SIDE_SHAPE))).m_61124_((Property)f_57952_, (Comparable)this.makeWallState(connectedNorth, shape, WALL_CONNECTION_SOUTH_SIDE_SHAPE))).m_61124_((Property)f_57953_, (Comparable)this.makeWallState(connectedEast, shape, WALL_CONNECTION_WEST_SIDE_SHAPE));
    }

    private WallSide makeWallState(boolean p_235633_1_, VoxelShape p_235633_2_, VoxelShape p_235633_3_) {
        if (p_235633_1_) {
            return DirtPathWall.compareShapes(p_235633_2_, p_235633_3_) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    private static boolean compareShapes(VoxelShape shape1, VoxelShape shape2) {
        return !Shapes.m_83157_((VoxelShape)shape2, (VoxelShape)shape1, (BooleanOp)BooleanOp.f_82685_);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (!this.m_7898_(state, (LevelReader)worldIn, pos)) {
            worldIn.m_46597_(pos, DirtPathWall.m_49897_((BlockState)state, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)WallInit.dirt_wall.get()).m_49966_().m_61124_((Property)f_57949_, (Comparable)((Boolean)state.m_61143_((Property)f_57949_)))).m_61124_((Property)f_57951_, (Comparable)((WallSide)state.m_61143_((Property)f_57951_)))).m_61124_((Property)f_57950_, (Comparable)((WallSide)state.m_61143_((Property)f_57950_)))).m_61124_((Property)f_57952_, (Comparable)((WallSide)state.m_61143_((Property)f_57952_)))).m_61124_((Property)f_57953_, (Comparable)((WallSide)state.m_61143_((Property)f_57953_)))).m_61124_((Property)f_57954_, (Comparable)((Boolean)state.m_61143_((Property)f_57954_)))), (Level)worldIn, (BlockPos)pos));
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.m_8055_(pos.m_7494_());
        return !blockstate.m_60767_().m_76333_() || blockstate.m_60734_() instanceof FenceGateBlock;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.stateToShapeMap.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.stateToCollisionShapeMap.get(state);
    }
}

