/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.walls;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FallingWall
extends FallingBlock {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final EnumProperty<WallSide> WALL_HEIGHT_EAST = BlockStateProperties.f_61378_;
    public static final EnumProperty<WallSide> WALL_HEIGHT_NORTH = BlockStateProperties.f_61379_;
    public static final EnumProperty<WallSide> WALL_HEIGHT_SOUTH = BlockStateProperties.f_61380_;
    public static final EnumProperty<WallSide> WALL_HEIGHT_WEST = BlockStateProperties.f_61381_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape POST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape NORTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TEST = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    private final Map<BlockState, VoxelShape> stateToShapeMap;
    private final Map<BlockState, VoxelShape> stateToCollisionShapeMap;

    public FallingWall(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.TRUE)).m_61124_(WALL_HEIGHT_NORTH, (Comparable)WallSide.NONE)).m_61124_(WALL_HEIGHT_EAST, (Comparable)WallSide.NONE)).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)WallSide.NONE)).m_61124_(WALL_HEIGHT_WEST, (Comparable)WallSide.NONE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.stateToShapeMap = this.makeShapes(4.0f, 3.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.stateToCollisionShapeMap = this.makeShapes(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape p_235631_0_, WallSide p_235631_1_, VoxelShape p_235631_2_, VoxelShape p_235631_3_) {
        if (p_235631_1_ == WallSide.TALL) {
            return Shapes.m_83110_((VoxelShape)p_235631_0_, (VoxelShape)p_235631_3_);
        }
        return p_235631_1_ == WallSide.LOW ? Shapes.m_83110_((VoxelShape)p_235631_0_, (VoxelShape)p_235631_2_) : p_235631_0_;
    }

    private static boolean isConnected(BlockState p_235629_0_, Property<WallSide> p_235629_1_) {
        return p_235629_0_.m_61143_(p_235629_1_) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape p_235632_0_, VoxelShape p_235632_1_) {
        return !Shapes.m_83157_((VoxelShape)p_235632_1_, (VoxelShape)p_235632_0_, (BooleanOp)BooleanOp.f_82685_);
    }

    private Map<BlockState, VoxelShape> makeShapes(float p_235624_1_, float p_235624_2_, float p_235624_3_, float p_235624_4_, float p_235624_5_, float p_235624_6_) {
        float f = 8.0f - p_235624_1_;
        float f1 = 8.0f + p_235624_1_;
        float f2 = 8.0f - p_235624_2_;
        float f3 = 8.0f + p_235624_2_;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)p_235624_3_, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)0.0, (double)f3, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)16.0, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape5 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)0.0, (double)f3, (double)p_235624_6_, (double)f3);
        VoxelShape voxelshape6 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_6_, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_6_, (double)f3);
        VoxelShape voxelshape8 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)16.0, (double)p_235624_6_, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean obool : UP.m_6908_()) {
            for (WallSide wallheight : WALL_HEIGHT_EAST.m_6908_()) {
                for (WallSide wallheight1 : WALL_HEIGHT_NORTH.m_6908_()) {
                    for (WallSide wallheight2 : WALL_HEIGHT_WEST.m_6908_()) {
                        for (WallSide wallheight3 : WALL_HEIGHT_SOUTH.m_6908_()) {
                            VoxelShape voxelshape9 = Shapes.m_83040_();
                            voxelshape9 = FallingWall.applyWallShape(voxelshape9, wallheight, voxelshape4, voxelshape8);
                            voxelshape9 = FallingWall.applyWallShape(voxelshape9, wallheight2, voxelshape3, voxelshape7);
                            voxelshape9 = FallingWall.applyWallShape(voxelshape9, wallheight1, voxelshape1, voxelshape5);
                            voxelshape9 = FallingWall.applyWallShape(voxelshape9, wallheight3, voxelshape2, voxelshape6);
                            if (obool.booleanValue()) {
                                voxelshape9 = Shapes.m_83110_((VoxelShape)voxelshape9, (VoxelShape)voxelshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)obool)).m_61124_(WALL_HEIGHT_EAST, (Comparable)wallheight)).m_61124_(WALL_HEIGHT_WEST, (Comparable)wallheight2)).m_61124_(WALL_HEIGHT_NORTH, (Comparable)wallheight1)).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)wallheight3);
                            builder.put((Object)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)), (Object)voxelshape9);
                            builder.put((Object)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE)), (Object)voxelshape9);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.stateToShapeMap.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.stateToCollisionShapeMap.get(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    private boolean connectsTo(BlockState state, boolean p_220113_2_, Direction direction) {
        Block block = state.m_60734_();
        boolean flag = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return state.m_60620_((Tag)BlockTags.f_13032_) || !FallingWall.m_152463_((BlockState)state) && p_220113_2_ || block instanceof IronBarsBlock || flag;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iworldreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos blockpos1 = blockpos.m_142127_();
        BlockPos blockpos2 = blockpos.m_142126_();
        BlockPos blockpos3 = blockpos.m_142128_();
        BlockPos blockpos4 = blockpos.m_142125_();
        BlockPos blockpos5 = blockpos.m_7494_();
        BlockState blockstate = iworldreader.m_8055_(blockpos1);
        BlockState blockstate1 = iworldreader.m_8055_(blockpos2);
        BlockState blockstate2 = iworldreader.m_8055_(blockpos3);
        BlockState blockstate3 = iworldreader.m_8055_(blockpos4);
        BlockState blockstate4 = iworldreader.m_8055_(blockpos5);
        boolean flag = this.connectsTo(blockstate, blockstate.m_60783_((BlockGetter)iworldreader, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.connectsTo(blockstate1, blockstate1.m_60783_((BlockGetter)iworldreader, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.connectsTo(blockstate2, blockstate2.m_60783_((BlockGetter)iworldreader, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.connectsTo(blockstate3, blockstate3.m_60783_((BlockGetter)iworldreader, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return this.updateShape((LevelReader)iworldreader, blockstate5, blockpos5, blockstate4, flag, flag1, flag2, flag3);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        worldIn.m_186460_(currentPos, (Block)this, this.m_7198_());
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return facing == Direction.UP ? this.topUpdate((LevelReader)worldIn, stateIn, facingPos, facingState) : this.sideUpdate((LevelReader)worldIn, currentPos, stateIn, facingPos, facingState, facing);
    }

    public void m_142216_(Level worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingBlock) {
        FluidState fluidstate = worldIn.m_6425_(pos);
        BlockPos blockpos1 = pos.m_142127_();
        BlockPos blockpos2 = pos.m_142126_();
        BlockPos blockpos3 = pos.m_142128_();
        BlockPos blockpos4 = pos.m_142125_();
        BlockPos blockpos5 = pos.m_7494_();
        BlockState blockstate = worldIn.m_8055_(blockpos1);
        BlockState blockstate1 = worldIn.m_8055_(blockpos2);
        BlockState blockstate2 = worldIn.m_8055_(blockpos3);
        BlockState blockstate3 = worldIn.m_8055_(blockpos4);
        BlockState blockstate4 = worldIn.m_8055_(blockpos5);
        boolean flag = this.connectsTo(blockstate, blockstate.m_60783_((BlockGetter)worldIn, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.connectsTo(blockstate1, blockstate1.m_60783_((BlockGetter)worldIn, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.connectsTo(blockstate2, blockstate2.m_60783_((BlockGetter)worldIn, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.connectsTo(blockstate3, blockstate3.m_60783_((BlockGetter)worldIn, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        BlockState bs = this.updateShape((LevelReader)worldIn, blockstate5, blockpos5, blockstate4, flag, flag1, flag2, flag3);
        worldIn.m_46597_(pos, bs);
    }

    private BlockState topUpdate(LevelReader p_235625_1_, BlockState p_235625_2_, BlockPos p_235625_3_, BlockState p_235625_4_) {
        boolean flag = FallingWall.isConnected(p_235625_2_, WALL_HEIGHT_NORTH);
        boolean flag1 = FallingWall.isConnected(p_235625_2_, WALL_HEIGHT_EAST);
        boolean flag2 = FallingWall.isConnected(p_235625_2_, WALL_HEIGHT_SOUTH);
        boolean flag3 = FallingWall.isConnected(p_235625_2_, WALL_HEIGHT_WEST);
        return this.updateShape(p_235625_1_, p_235625_2_, p_235625_3_, p_235625_4_, flag, flag1, flag2, flag3);
    }

    private BlockState sideUpdate(LevelReader p_235627_1_, BlockPos p_235627_2_, BlockState p_235627_3_, BlockPos p_235627_4_, BlockState p_235627_5_, Direction p_235627_6_) {
        Direction direction = p_235627_6_.m_122424_();
        boolean flag = p_235627_6_ == Direction.NORTH ? this.connectsTo(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)p_235627_1_, p_235627_4_, direction), direction) : FallingWall.isConnected(p_235627_3_, WALL_HEIGHT_NORTH);
        boolean flag1 = p_235627_6_ == Direction.EAST ? this.connectsTo(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)p_235627_1_, p_235627_4_, direction), direction) : FallingWall.isConnected(p_235627_3_, WALL_HEIGHT_EAST);
        boolean flag2 = p_235627_6_ == Direction.SOUTH ? this.connectsTo(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)p_235627_1_, p_235627_4_, direction), direction) : FallingWall.isConnected(p_235627_3_, WALL_HEIGHT_SOUTH);
        boolean flag3 = p_235627_6_ == Direction.WEST ? this.connectsTo(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)p_235627_1_, p_235627_4_, direction), direction) : FallingWall.isConnected(p_235627_3_, WALL_HEIGHT_WEST);
        BlockPos blockpos = p_235627_2_.m_7494_();
        BlockState blockstate = p_235627_1_.m_8055_(blockpos);
        return this.updateShape(p_235627_1_, p_235627_3_, blockpos, blockstate, flag, flag1, flag2, flag3);
    }

    private BlockState updateShape(LevelReader p_235626_1_, BlockState p_235626_2_, BlockPos p_235626_3_, BlockState p_235626_4_, boolean p_235626_5_, boolean p_235626_6_, boolean p_235626_7_, boolean p_235626_8_) {
        VoxelShape voxelshape = p_235626_4_.m_60816_((BlockGetter)p_235626_1_, p_235626_3_).m_83263_(Direction.DOWN);
        BlockState blockstate = this.updateSides(p_235626_2_, p_235626_5_, p_235626_6_, p_235626_7_, p_235626_8_, voxelshape);
        return (BlockState)blockstate.m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.shouldRaisePost(blockstate, p_235626_4_, voxelshape)));
    }

    private boolean shouldRaisePost(BlockState p_235628_1_, BlockState p_235628_2_, VoxelShape p_235628_3_) {
        boolean flag6;
        boolean flag5;
        boolean flag;
        boolean bl = flag = p_235628_2_.m_60734_() instanceof WallBlock && (Boolean)p_235628_2_.m_61143_((Property)UP) != false;
        if (flag) {
            return true;
        }
        WallSide wallheight = (WallSide)p_235628_1_.m_61143_(WALL_HEIGHT_NORTH);
        WallSide wallheight1 = (WallSide)p_235628_1_.m_61143_(WALL_HEIGHT_SOUTH);
        WallSide wallheight2 = (WallSide)p_235628_1_.m_61143_(WALL_HEIGHT_EAST);
        WallSide wallheight3 = (WallSide)p_235628_1_.m_61143_(WALL_HEIGHT_WEST);
        boolean flag1 = wallheight1 == WallSide.NONE;
        boolean flag2 = wallheight3 == WallSide.NONE;
        boolean flag3 = wallheight2 == WallSide.NONE;
        boolean flag4 = wallheight == WallSide.NONE;
        boolean bl2 = flag5 = flag4 && flag1 && flag2 && flag3 || flag4 != flag1 || flag2 != flag3;
        if (flag5) {
            return true;
        }
        boolean bl3 = flag6 = wallheight == WallSide.TALL && wallheight1 == WallSide.TALL || wallheight2 == WallSide.TALL && wallheight3 == WallSide.TALL;
        if (flag6) {
            return false;
        }
        return p_235628_2_.m_60620_((Tag)BlockTags.f_13081_) || FallingWall.isCovered(p_235628_3_, POST_TEST);
    }

    private BlockState updateSides(BlockState p_235630_1_, boolean p_235630_2_, boolean p_235630_3_, boolean p_235630_4_, boolean p_235630_5_, VoxelShape p_235630_6_) {
        return (BlockState)((BlockState)((BlockState)((BlockState)p_235630_1_.m_61124_(WALL_HEIGHT_NORTH, (Comparable)this.makeWallState(p_235630_2_, p_235630_6_, NORTH_TEST))).m_61124_(WALL_HEIGHT_EAST, (Comparable)this.makeWallState(p_235630_3_, p_235630_6_, EAST_TEST))).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)this.makeWallState(p_235630_4_, p_235630_6_, SOUTH_TEST))).m_61124_(WALL_HEIGHT_WEST, (Comparable)this.makeWallState(p_235630_5_, p_235630_6_, WEST_TEST));
    }

    private WallSide makeWallState(boolean p_235633_1_, VoxelShape p_235633_2_, VoxelShape p_235633_3_) {
        if (p_235633_1_) {
            return FallingWall.isCovered(p_235633_2_, p_235633_3_) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, WALL_HEIGHT_NORTH, WALL_HEIGHT_EAST, WALL_HEIGHT_WEST, WALL_HEIGHT_SOUTH, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(WALL_HEIGHT_NORTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_SOUTH)))).m_61124_(WALL_HEIGHT_EAST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_WEST)))).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_NORTH)))).m_61124_(WALL_HEIGHT_WEST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(WALL_HEIGHT_NORTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_EAST)))).m_61124_(WALL_HEIGHT_EAST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_SOUTH)))).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_WEST)))).m_61124_(WALL_HEIGHT_WEST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(WALL_HEIGHT_NORTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_WEST)))).m_61124_(WALL_HEIGHT_EAST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_NORTH)))).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_EAST)))).m_61124_(WALL_HEIGHT_WEST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_SOUTH)));
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return switch (mirrorIn) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_(WALL_HEIGHT_NORTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_SOUTH)))).m_61124_(WALL_HEIGHT_SOUTH, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_(WALL_HEIGHT_EAST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_WEST)))).m_61124_(WALL_HEIGHT_WEST, (Comparable)((WallSide)state.m_61143_(WALL_HEIGHT_EAST)));
            default -> super.m_6943_(state, mirrorIn);
        };
    }
}

