/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.vanillaextension.walls;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RedstoneLampWall
extends WallBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private final Map<BlockState, VoxelShape> stateToShapeMap;
    private final Map<BlockState, VoxelShape> stateToCollisionShapeMap;

    public RedstoneLampWall(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
        this.stateToShapeMap = this.makeShapes(4.0f, 3.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.stateToCollisionShapeMap = this.makeShapes(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static VoxelShape getHeightAlteredShape(VoxelShape baseShape, WallSide height, VoxelShape lowShape, VoxelShape tallShape) {
        if (height == WallSide.TALL) {
            return Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)tallShape);
        }
        return height == WallSide.LOW ? Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)lowShape) : baseShape;
    }

    private Map<BlockState, VoxelShape> makeShapes(float p_235624_1_, float p_235624_2_, float p_235624_3_, float p_235624_4_, float p_235624_5_, float p_235624_6_) {
        float f = 8.0f - p_235624_1_;
        float f1 = 8.0f + p_235624_1_;
        float f2 = 8.0f - p_235624_2_;
        float f3 = 8.0f + p_235624_2_;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)p_235624_3_, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)0.0, (double)f3, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)16.0, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape5 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)0.0, (double)f3, (double)p_235624_6_, (double)f3);
        VoxelShape voxelshape6 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_6_, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_6_, (double)f3);
        VoxelShape voxelshape8 = Block.m_49796_((double)f2, (double)p_235624_4_, (double)f2, (double)16.0, (double)p_235624_6_, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean obool : f_57949_.m_6908_()) {
            for (WallSide wallheight : f_57950_.m_6908_()) {
                for (WallSide wallheight1 : f_57951_.m_6908_()) {
                    for (WallSide wallheight2 : f_57953_.m_6908_()) {
                        for (WallSide wallheight3 : f_57952_.m_6908_()) {
                            VoxelShape voxelshape9 = Shapes.m_83040_();
                            voxelshape9 = RedstoneLampWall.getHeightAlteredShape(voxelshape9, wallheight, voxelshape4, voxelshape8);
                            voxelshape9 = RedstoneLampWall.getHeightAlteredShape(voxelshape9, wallheight2, voxelshape3, voxelshape7);
                            voxelshape9 = RedstoneLampWall.getHeightAlteredShape(voxelshape9, wallheight1, voxelshape1, voxelshape5);
                            voxelshape9 = RedstoneLampWall.getHeightAlteredShape(voxelshape9, wallheight3, voxelshape2, voxelshape6);
                            if (obool.booleanValue()) {
                                voxelshape9 = Shapes.m_83110_((VoxelShape)voxelshape9, (VoxelShape)voxelshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_57949_, (Comparable)obool)).m_61124_((Property)f_57950_, (Comparable)wallheight)).m_61124_((Property)f_57953_, (Comparable)wallheight2)).m_61124_((Property)f_57951_, (Comparable)wallheight1)).m_61124_((Property)f_57952_, (Comparable)wallheight3);
                            builder.put((Object)((BlockState)((BlockState)blockstate.m_61124_((Property)f_57954_, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE)), (Object)voxelshape9);
                            builder.put((Object)((BlockState)((BlockState)blockstate.m_61124_((Property)f_57954_, (Comparable)Boolean.TRUE)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE)), (Object)voxelshape9);
                            builder.put((Object)((BlockState)((BlockState)blockstate.m_61124_((Property)f_57954_, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.TRUE)), (Object)voxelshape9);
                            builder.put((Object)((BlockState)((BlockState)blockstate.m_61124_((Property)f_57954_, (Comparable)Boolean.TRUE)).m_61124_((Property)LIT, (Comparable)Boolean.TRUE)), (Object)voxelshape9);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.stateToShapeMap.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.stateToCollisionShapeMap.get(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(context.m_43725_().m_46753_(context.m_8083_())));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.f_46443_ && (flag = ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) != worldIn.m_46753_(pos)) {
            if (flag) {
                worldIn.m_186460_(pos, (Block)this, 4);
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !worldIn.m_46753_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT});
    }
}

