/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class RPUtils {
    public static ResourceLocation resPath(ResourceLocation relativeLocation, ResType type) {
        return new ResourceLocation(relativeLocation.m_135827_(), String.format(type.loc, relativeLocation.m_135815_()));
    }

    public static ResourceLocation resPath(String relativeLocation, ResType type) {
        return RPUtils.resPath(new ResourceLocation(relativeLocation), type);
    }

    public static String serializeJson(JsonElement json) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        jsonWriter.setLenient(true);
        jsonWriter.setIndent("  ");
        Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
        return stringWriter.toString();
    }

    public static JsonObject deserializeJson(InputStream stream) {
        JsonElement element = new JsonParser().parse((Reader)new InputStreamReader(stream));
        return element.getAsJsonObject();
    }

    public static NativeImage findFirstBlockTexture(ResourceManager manager, Block block) throws FileNotFoundException {
        String loc = RPUtils.findFirstBlockTextureLocation(manager, block, s -> true);
        try {
            return NativeImage.m_85058_((InputStream)manager.m_142591_(RPUtils.resPath(loc, ResType.TEXTURES)).m_6679_());
        }
        catch (IOException e) {
            throw new FileNotFoundException("Could not resolve texture " + loc);
        }
    }

    public static NativeImage findFirstItemTexture(ResourceManager manager, Item item) throws FileNotFoundException {
        String loc = RPUtils.findFirstItemTextureLocation(manager, item, s -> true);
        try {
            return NativeImage.m_85058_((InputStream)manager.m_142591_(RPUtils.resPath(loc, ResType.TEXTURES)).m_6679_());
        }
        catch (IOException e) {
            throw new FileNotFoundException("Could not resolve texture " + loc);
        }
    }

    public static String findFirstBlockTextureLocation(ResourceManager manager, Block block, Predicate<String> texturePredicate) throws FileNotFoundException {
        try {
            ResourceLocation res = block.getRegistryName();
            Resource blockState = manager.m_142591_(RPUtils.resPath(res, ResType.BLOCKSTATES));
            JsonObject bsElement = RPUtils.deserializeJson(blockState.m_6679_());
            String modelPath = RPUtils.findFirstResourceInJsonRecursive(bsElement.getAsJsonObject().get("variants"));
            Resource model = manager.m_142591_(RPUtils.resPath(modelPath, ResType.MODELS));
            JsonObject modelElement = RPUtils.deserializeJson(model.m_6679_());
            return RPUtils.findAllResourcesInJsonRecursive((JsonElement)modelElement.getAsJsonObject().getAsJsonObject("textures")).stream().filter(texturePredicate).findAny().get();
        }
        catch (Exception e) {
            throw new FileNotFoundException("Could not find any texture associated to the given block " + block.getRegistryName());
        }
    }

    public static String findFirstItemTextureLocation(ResourceManager manager, Item item, Predicate<String> texturePredicate) throws FileNotFoundException {
        try {
            ResourceLocation res = item.getRegistryName();
            Resource itemModel = manager.m_142591_(RPUtils.resPath(res, ResType.ITEM_MODELS));
            JsonObject bsElement = RPUtils.deserializeJson(itemModel.m_6679_());
            return RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject().getAsJsonObject("textures")).stream().filter(texturePredicate).findAny().get();
        }
        catch (Exception e) {
            throw new FileNotFoundException("Could not find any texture associated to the given item " + item.getRegistryName());
        }
    }

    public static String findFirstResourceInJsonRecursive(JsonElement element) throws NoSuchElementException {
        if (element instanceof JsonObject) {
            Set entries = element.getAsJsonObject().entrySet();
            JsonElement child = (JsonElement)((Map.Entry)entries.stream().findAny().get()).getValue();
            return RPUtils.findFirstResourceInJsonRecursive(child);
        }
        return element.getAsString();
    }

    public static List<String> findAllResourcesInJsonRecursive(JsonElement element) {
        if (element instanceof JsonObject) {
            Set entries = element.getAsJsonObject().entrySet();
            Stream<JsonElement> children = entries.stream().map(Map.Entry::getValue);
            ArrayList<String> list = new ArrayList<String>();
            children.map(RPUtils::findAllResourcesInJsonRecursive).forEach(list::addAll);
            return list;
        }
        return List.of(element.getAsString());
    }

    public static enum ResType {
        GENERIC("%s"),
        TAGS("tags/%s.json"),
        LOOT_TABLES("loot_tables/%s.json"),
        RECIPES("recipes/%s.json"),
        ADVANCEMENTS("advancements/%s.json"),
        LANG("lang/%s.json"),
        TEXTURES("textures/%s.png"),
        BLOCK_TEXTURES("textures/block/%s.png"),
        ITEM_TEXTURES("textures/item/%s.png"),
        ENTITY_TEXTURES("textures/entity/%s.png"),
        MCMETA("textures/%s.png.mcmeta"),
        BLOCK_MCMETA("textures/block/%s.png.mcmeta"),
        ITEM_MCMETA("textures/item/%s.png.mcmeta"),
        MODELS("models/%s.json"),
        BLOCK_MODELS("models/block/%s.json"),
        ITEM_MODELS("models/item/%s.json"),
        BLOCKSTATES("blockstates/%s.json");

        public final String loc;

        private ResType(String loc) {
            this.loc = loc;
        }
    }

    public static class StaticResource {
        public final byte[] data;
        public final ResourceLocation location;
        public final String sourceName;

        public StaticResource(Resource original) {
            byte[] data1;
            try {
                data1 = original.m_6679_().readAllBytes();
            }
            catch (IOException e) {
                data1 = new byte[]{};
            }
            this.data = data1;
            this.location = original.m_7843_();
            this.sourceName = original.m_7816_();
        }
    }
}

