/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.textures;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.mehvahdjukaar.selene.textures.PaletteColor;
import org.jetbrains.annotations.Nullable;

public class Palette {
    private static final Comparator<PaletteColor> COMPARATOR = (a, b) -> Float.compare(a.luminance, b.luminance);
    private final ArrayList<PaletteColor> internal = new ArrayList();

    public int size() {
        return this.internal.size();
    }

    public List<PaletteColor> getValues() {
        return this.internal;
    }

    private void sort() {
        this.internal.sort(COMPARATOR);
    }

    public Palette(Collection<PaletteColor> colors) {
        this.internal.addAll(colors);
        this.sort();
    }

    public void add(PaletteColor color) {
        this.internal.add(color);
        this.sort();
    }

    public void add(int index, PaletteColor color) {
        this.internal.add(index, color);
        this.sort();
    }

    public void set(int index, PaletteColor color) {
        this.internal.set(index, color);
    }

    public PaletteColor get(int index) {
        return this.internal.get(index);
    }

    public void remove(int index) {
        this.internal.remove(index);
        this.sort();
    }

    public void remove(PaletteColor color) {
        this.internal.remove(color);
        this.sort();
    }

    public static Palette fromImage(NativeImage image) {
        return Palette.fromImage(image, null);
    }

    public static Palette fromImage(NativeImage image, @Nullable NativeImage mask) {
        HashMap<Integer, PaletteColor> map = new HashMap<Integer, PaletteColor>();
        for (int x = 0; x < image.m_84982_(); ++x) {
            for (int y = 0; y < image.m_85084_(); ++y) {
                int color;
                if (mask != null && NativeImage.m_84983_((int)mask.m_84985_(x, y)) != 0 || NativeImage.m_84983_((int)(color = image.m_84985_(x, y))) == 0) continue;
                int finalX = x;
                int finalY = y;
                PaletteColor paletteColor = map.computeIfAbsent(color, p -> new PaletteColor(finalX, finalY, color));
                ++paletteColor.occurrence;
            }
        }
        return new Palette(map.values());
    }

    public void matchSize(int targetSize) {
        this.maybeReducePalette(targetSize);
        this.maybeIncreasePalette(targetSize);
    }

    private void maybeReducePalette(int targetSize) {
        while (this.internal.size() > targetSize) {
            PaletteColor toRemove = this.internal.get(0);
            for (PaletteColor p : this.internal) {
                if (p.occurrence >= toRemove.occurrence) continue;
                toRemove = p;
            }
            this.internal.remove(toRemove);
        }
        this.sort();
    }

    private void maybeIncreasePalette(int targetSize) {
        while (this.internal.size() < targetSize) {
            float lastLum = 0.0f;
            int ind = 0;
            for (int i = 1; i < this.internal.size(); ++i) {
                float d = this.internal.get((int)i).luminance - this.internal.get((int)(i - 1)).luminance;
                if (!(d > lastLum)) continue;
                lastLum = d;
                ind = i;
            }
            int color0 = this.internal.get((int)(ind - 1)).color;
            int color1 = this.internal.get((int)ind).color;
            int r = (int)((float)(NativeImage.m_85085_((int)color0) + NativeImage.m_85085_((int)color1)) / 2.0f);
            int g = (int)((float)(NativeImage.m_85103_((int)color0) + NativeImage.m_85103_((int)color1)) / 2.0f);
            int b = (int)((float)(NativeImage.m_85119_((int)color0) + NativeImage.m_85119_((int)color1)) / 2.0f);
            int newColor = NativeImage.m_84992_((int)255, (int)b, (int)g, (int)r);
            this.internal.add(new PaletteColor(0, 0, newColor));
            this.sort();
        }
    }
}

