/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.textures;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Arrays;
import net.mehvahdjukaar.selene.textures.Palette;
import net.mehvahdjukaar.selene.textures.PaletteColor;
import net.minecraft.util.Mth;

public class SpriteUtils {
    public static void mergeImages(NativeImage baseImage, NativeImage ... overlays) throws IllegalStateException {
        int width = baseImage.m_84982_();
        int height = baseImage.m_85084_();
        if (Arrays.stream(overlays).anyMatch(n -> n.m_85084_() != height || n.m_84982_() != width)) {
            throw new IllegalStateException("Could not merge images because they had different dimensions");
        }
        for (NativeImage o : overlays) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    baseImage.m_166411_(x, y, o.m_84985_(x, y));
                }
            }
        }
    }

    public static Palette extrapolateSignBlockPalette(NativeImage planksTexture) {
        Palette palette = Palette.fromImage(planksTexture, null);
        int size = palette.size();
        if (size == 7) {
            PaletteColor color = palette.get(size - 3);
            float[] hsv = SpriteUtils.RGBtoHSV(color.color);
            float satIncrease = 1.0638298f;
            float brightnessIncrease = 1.0638298f;
            int newCol = SpriteUtils.HSVtoRGB(hsv[0], hsv[1] * satIncrease, hsv[2] * brightnessIncrease);
            PaletteColor newP = new PaletteColor(color.x, color.y, newCol);
            newP.occurrence = color.occurrence;
            palette.set(size - 1, newP);
            palette.remove(size - 2);
        }
        return palette;
    }

    public static Palette extrapolateWoodItemPalette(NativeImage planksTexture) {
        Palette palette = Palette.fromImage(planksTexture, null);
        PaletteColor color = palette.get(0);
        float[] hsv = SpriteUtils.RGBtoHSV(color.color);
        float satIncrease = 1.11f;
        float brightnessIncrease = 0.945f;
        int newCol = SpriteUtils.HSVtoRGB(hsv[0], hsv[1] * satIncrease, hsv[2] * brightnessIncrease);
        PaletteColor newP = new PaletteColor(color.x, color.y, newCol);
        newP.occurrence = color.occurrence;
        palette.set(0, newP);
        return palette;
    }

    public static float getLuminance(int r, int g, int b) {
        return 0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b;
    }

    public static int HSVtoRGB(float hue, float saturation, float brightness) {
        hue = Mth.m_14036_((float)hue, (float)0.0f, (float)1.0f);
        saturation = Mth.m_14036_((float)saturation, (float)0.0f, (float)1.0f);
        brightness = Mth.m_14036_((float)brightness, (float)0.0f, (float)1.0f);
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        r = Mth.m_14045_((int)r, (int)0, (int)255);
        g = Mth.m_14045_((int)g, (int)0, (int)255);
        b = Mth.m_14045_((int)b, (int)0, (int)255);
        return NativeImage.m_84992_((int)255, (int)b, (int)g, (int)r);
    }

    public static float[] RGBtoHSV(int rgb) {
        float hue;
        int cmin;
        int r = NativeImage.m_85085_((int)rgb);
        int g = NativeImage.m_85103_((int)rgb);
        int b = NativeImage.m_85119_((int)rgb);
        float[] hsbvals = new float[3];
        int cmax = Math.max(r, g);
        if (b > cmax) {
            cmax = b;
        }
        if (b < (cmin = Math.min(r, g))) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }
}

