/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.util;

import java.io.Serializable;
import java.util.Optional;
import net.mehvahdjukaar.selene.resourcepack.AssetGenerators;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class WoodSetType {
    public static WoodSetType OAK_WOOD_TYPE = new WoodSetType(new ResourceLocation("oak"), Blocks.f_50705_, Blocks.f_49999_);
    public final ResourceLocation id;
    public final Material material;
    public final Block plankBlock;
    public final String shortenedNamespace;
    @Nullable
    public final Block logBlock;
    @Nullable
    public final Lazy<Item> signItem;

    protected WoodSetType(ResourceLocation id, Block baseBlock, Block logBlock) {
        this.id = id;
        this.plankBlock = baseBlock;
        this.logBlock = logBlock;
        this.material = baseBlock.m_49966_().m_60767_();
        this.shortenedNamespace = id.m_135827_().equals("minecraft") ? "" : "_" + WoodSetType.abbreviateString(id.m_135827_());
        this.signItem = Lazy.of(this::findSign);
    }

    @Nullable
    private Item findSign() {
        ResourceLocation[] test2 = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_sign"), new ResourceLocation(this.id.m_135827_(), "sign_" + this.id.m_135815_())};
        Item temp2 = null;
        for (ResourceLocation r : test2) {
            if (!ForgeRegistries.ITEMS.containsKey(r)) continue;
            temp2 = (Item)ForgeRegistries.ITEMS.getValue(r);
            break;
        }
        return temp2;
    }

    public String toString() {
        return this.id.toString();
    }

    public String getWoodName() {
        return this.id.m_135815_();
    }

    public String getNamespace() {
        return this.id.m_135827_();
    }

    public String getNameForTranslation(String append) {
        return AssetGenerators.LangBuilder.getReadableName(this.getWoodName() + "_" + append);
    }

    @Deprecated
    public String getAppendableId() {
        return this.getWoodName() + this.shortenedNamespace;
    }

    public String getVariantId(String baseName) {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return baseName + "_" + this.getWoodName();
        }
        return this.getNamespace() + "/" + baseName + "_" + this.getWoodName();
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getWoodName();
        }
        return this.getNamespace() + "/" + this.getWoodName();
    }

    public boolean canBurn() {
        return this.material.m_76335_();
    }

    public MaterialColor getColor() {
        return this.material.m_76339_();
    }

    public boolean isVanilla() {
        return this.getNamespace().equals("minecraft");
    }

    private static String abbreviateString(String string) {
        if (string.length() <= 5) {
            return string;
        }
        String[] a = string.split("_");
        if (a.length > 2) {
            return "" + a[0].charAt(0) + a[1].charAt(0) + a[2].charAt(0) + (Serializable)(a.length > 3 ? Character.valueOf(a[3].charAt(0)) : "");
        }
        if (a.length > 1) {
            return a[0].substring(0, Math.min(2, a[0].length())) + a[1].substring(0, Math.min(2, a[0].length()));
        }
        return string.substring(0, 4);
    }

    @Nullable
    private static Block findLog(ResourceLocation id) {
        ResourceLocation[] test = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), id.m_135815_() + "_log"), new ResourceLocation(id.m_135827_(), "log_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_log"), new ResourceLocation("log_" + id.m_135815_()), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_stem"), new ResourceLocation(id.m_135827_(), "stem_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_stem"), new ResourceLocation("stem_" + id.m_135815_())};
        Block temp = null;
        for (ResourceLocation r : test) {
            if (!ForgeRegistries.BLOCKS.containsKey(r)) continue;
            temp = (Block)ForgeRegistries.BLOCKS.getValue(r);
            break;
        }
        return temp;
    }

    public static Optional<WoodSetType> getWoodTypeFromBlock(Block baseBlock) {
        ResourceLocation id;
        Block logBlock;
        BlockState state;
        Material mat;
        ResourceLocation baseRes = baseBlock.getRegistryName();
        String name = null;
        String path = baseRes.m_135815_();
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        if (name != null && ((mat = (state = baseBlock.m_49966_()).m_60767_()) == Material.f_76320_ || mat == Material.f_76321_) && (logBlock = WoodSetType.findLog(id = new ResourceLocation(baseRes.m_135827_(), name))) != null) {
            return Optional.of(new WoodSetType(id, baseBlock, logBlock));
        }
        return Optional.empty();
    }
}

