/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp.xpblock;

import bl4ckscor3.mod.globalxp.Configuration;
import bl4ckscor3.mod.globalxp.GlobalXP;
import bl4ckscor3.mod.globalxp.openmods.utils.EnchantmentUtils;
import bl4ckscor3.mod.globalxp.xpblock.XPBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class XPBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0E-4, (double)1.0E-4, (double)1.0E-4, (double)15.999, (double)15.999, (double)15.999);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public XPBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(12.5f, 2000.0f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof XPBlockEntity) {
            XPBlockEntity xpBlock = (XPBlockEntity)blockEntity;
            if (!level.f_46443_) {
                if (player.m_6144_()) {
                    int xpToStore = 0;
                    if ((Integer)Configuration.SERVER.storingAmount.get() != -1) {
                        xpToStore = Math.min((Integer)Configuration.SERVER.storingAmount.get(), EnchantmentUtils.getPlayerXP(player));
                    } else if (((Boolean)Configuration.SERVER.storeUntilPreviousLevel.get()).booleanValue()) {
                        int xpForCurrentLevel = EnchantmentUtils.getExperienceForLevel(player.f_36078_);
                        xpToStore = EnchantmentUtils.getPlayerXP(player) - xpForCurrentLevel;
                        if (xpToStore == 0 && player.f_36078_ > 0) {
                            xpToStore = xpForCurrentLevel - EnchantmentUtils.getExperienceForLevel(player.f_36078_ - 1);
                        }
                    } else {
                        xpToStore = EnchantmentUtils.getPlayerXP(player);
                    }
                    if (xpToStore == 0) {
                        return InteractionResult.PASS;
                    }
                    xpBlock.addXP(xpToStore);
                    EnchantmentUtils.addPlayerXP(player, -xpToStore);
                    return InteractionResult.SUCCESS;
                }
                if (!player.m_6144_()) {
                    if ((Integer)Configuration.SERVER.retrievalAmount.get() != -1) {
                        int xpRetrieved = (int)((double)xpBlock.removeXP((Integer)Configuration.SERVER.retrievalAmount.get()) * (Double)Configuration.SERVER.retrievalPercentage.get());
                        EnchantmentUtils.addPlayerXP(player, xpRetrieved);
                    } else if (((Boolean)Configuration.SERVER.retriveUntilNextLevel.get()).booleanValue()) {
                        int xpToRetrieve = EnchantmentUtils.getExperienceForLevel(player.f_36078_ + 1) - EnchantmentUtils.getPlayerXP(player);
                        int actuallyRemoved = (int)((double)xpBlock.removeXP(xpToRetrieve) * (Double)Configuration.SERVER.retrievalPercentage.get());
                        EnchantmentUtils.addPlayerXP(player, actuallyRemoved);
                    } else {
                        EnchantmentUtils.addPlayerXP(player, (int)((double)xpBlock.getStoredXP() * (Double)Configuration.SERVER.retrievalPercentage.get()));
                        xpBlock.setStoredXP(0);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof XPBlockEntity) {
            XPBlockEntity xpBlock = (XPBlockEntity)blockEntity;
            return Math.min(15, Math.floorDiv(xpBlock.getStoredXP(), (int)((Integer)Configuration.SERVER.xpForComparator.get())));
        }
        return 0;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (level.f_46443_ || !stack.m_41782_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof XPBlockEntity) {
            XPBlockEntity xpBlock = (XPBlockEntity)blockEntity;
            CompoundTag tag = stack.m_41783_().m_128469_("BlockEntityTag");
            tag.m_128405_("x", pos.m_123341_());
            tag.m_128405_("y", pos.m_123342_());
            tag.m_128405_("z", pos.m_123343_());
            xpBlock.m_142466_(tag);
            xpBlock.m_6596_();
            level.m_7260_(pos, state, state, 2);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof XPBlockEntity) {
            XPBlockEntity xpBlock = (XPBlockEntity)blockEntity;
            xpBlock.setDestroyedByCreativePlayer(player.m_7500_());
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof XPBlockEntity) {
            XPBlockEntity xpBlock = (XPBlockEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
            if (xpBlock.getStoredLevels() != 0.0f) {
                CompoundTag stackTag = new CompoundTag();
                stackTag.m_128365_("BlockEntityTag", (Tag)xpBlock.m_187482_());
                stack.m_41751_(stackTag);
                XPBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
            } else if (!xpBlock.isDestroyedByCreativePlayer()) {
                XPBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_46753_(pos))));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new XPBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : XPBlock.m_152132_(type, GlobalXP.beTypeXpBlock, XPBlockEntity::serverTick);
    }
}

