/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp.xpblock;

import bl4ckscor3.mod.globalxp.Configuration;
import bl4ckscor3.mod.globalxp.GlobalXP;
import bl4ckscor3.mod.globalxp.XPUtils;
import bl4ckscor3.mod.globalxp.xpblock.XPBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class XPBlockEntity
extends BlockEntity {
    private int storedXP = 0;
    private float storedLevels = 0.0f;
    private boolean destroyedByCreativePlayer;

    public XPBlockEntity(BlockPos pos, BlockState state) {
        super(GlobalXP.beTypeXpBlock, pos, state);
    }

    public void addXP(int amount) {
        this.storedXP += amount;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
    }

    public int removeXP(int amount) {
        int amountRemoved = Math.min(amount, this.storedXP);
        if (amountRemoved <= 0) {
            return 0;
        }
        this.storedXP -= amountRemoved;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
        return amountRemoved;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void setStoredXP(int xp) {
        this.storedXP = xp;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public float getStoredLevels() {
        return this.storedLevels;
    }

    public void setDestroyedByCreativePlayer(boolean destroyedByCreativePlayer) {
        this.destroyedByCreativePlayer = destroyedByCreativePlayer;
    }

    public boolean isDestroyedByCreativePlayer() {
        return this.destroyedByCreativePlayer;
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("stored_xp", this.storedXP);
    }

    public void m_142466_(CompoundTag tag) {
        this.setStoredXP(tag.m_128451_("stored_xp"));
        super.m_142466_(tag);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, XPBlockEntity be) {
        if (level.m_46467_() % 5L == 0L && ((Boolean)Configuration.SERVER.pickupXP.get()).booleanValue() && !((Boolean)state.m_61143_((Property)XPBlock.POWERED)).booleanValue()) {
            be.pickupDroppedXP();
        }
    }

    private void pickupDroppedXP() {
        for (ExperienceOrb entity : this.f_58857_.m_6443_(ExperienceOrb.class, this.getPickupArea(), EntitySelector.f_20402_)) {
            int amount = entity.m_20801_();
            if (this.getStoredXP() + amount > this.getCapacity()) continue;
            this.addXP(amount);
            entity.m_146870_();
        }
    }

    private AABB getPickupArea() {
        double x = (double)this.m_58899_().m_123341_() + 0.5;
        double y = (double)this.m_58899_().m_123342_() + 0.5;
        double z = (double)this.m_58899_().m_123343_() + 0.5;
        double range = (Double)Configuration.SERVER.pickupRange.get() + 0.5;
        return new AABB(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }
}

