/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.color;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import mezz.jei.color.ColorUtil;
import mezz.jei.util.Translator;
import org.jetbrains.annotations.Nullable;

public class ColorNamer {
    private final ImmutableMap<Integer, String> colorNames;

    public ColorNamer(ImmutableMap<Integer, String> colorNames) {
        this.colorNames = colorNames;
    }

    public Collection<String> getColorNames(Iterable<Integer> colors, boolean lowercase) {
        LinkedHashSet<String> allColorNames = new LinkedHashSet<String>();
        for (Integer color : colors) {
            String colorName = this.getClosestColorName(color);
            if (colorName == null) continue;
            if (lowercase) {
                allColorNames.add(Translator.toLowercaseWithLocale(colorName));
                continue;
            }
            allColorNames.add(colorName);
        }
        return allColorNames;
    }

    @Nullable
    private String getClosestColorName(Integer color) {
        if (this.colorNames.isEmpty()) {
            return null;
        }
        String closestColorName = null;
        double closestColorDistance = Double.MAX_VALUE;
        for (Map.Entry entry : this.colorNames.entrySet()) {
            Integer namedColor = (Integer)entry.getKey();
            double distance = ColorUtil.slowPerceptualColorDistanceSquared(namedColor, color);
            double absDistance = Math.abs(distance);
            if (!(absDistance < closestColorDistance)) continue;
            closestColorDistance = absDistance;
            closestColorName = (String)entry.getValue();
        }
        return closestColorName;
    }
}

