/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.ServerInfo;
import mezz.jei.ingredients.IngredientInfo;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.ingredients.TypedIngredient;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BookmarkConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MARKER_OTHER = "O:";
    private static final String MARKER_STACK = "T:";
    private final File jeiConfigurationDir;

    @Nullable
    private static File getFile(File jeiConfigurationDir) {
        Path configPath = ServerInfo.getWorldPath(jeiConfigurationDir.toPath());
        if (configPath == null) {
            return null;
        }
        return configPath.resolve("bookmarks.ini").toFile();
    }

    private static File getOldFile(File jeiConfigurationDir) {
        return Path.of(jeiConfigurationDir.getAbsolutePath(), "bookmarks.ini").toFile();
    }

    public BookmarkConfig(File jeiConfigurationDir) {
        this.jeiConfigurationDir = jeiConfigurationDir;
    }

    public void saveBookmarks(RegisteredIngredients registeredIngredients, List<ITypedIngredient<?>> ingredientList) {
        File file = BookmarkConfig.getFile(this.jeiConfigurationDir);
        if (file == null) {
            return;
        }
        ArrayList<CallSite> strings = new ArrayList<CallSite>();
        for (ITypedIngredient<?> typedIngredient : ingredientList) {
            Object obj = typedIngredient.getIngredient();
            if (obj instanceof ItemStack) {
                ItemStack stack = (ItemStack)obj;
                strings.add((CallSite)((Object)(MARKER_STACK + stack.m_41739_(new CompoundTag()))));
                continue;
            }
            strings.add((CallSite)((Object)(MARKER_OTHER + BookmarkConfig.getUid(registeredIngredients, typedIngredient))));
        }
        try (FileWriter writer = new FileWriter(file);){
            IOUtils.writeLines(strings, (String)"\n", (Writer)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save bookmarks list to file {}", (Object)file, (Object)e);
        }
    }

    public void loadBookmarks(RegisteredIngredients registeredIngredients, BookmarkList bookmarkList) {
        List ingredientJsonStrings;
        File file = BookmarkConfig.getFile(this.jeiConfigurationDir);
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            File oldFile = BookmarkConfig.getOldFile(this.jeiConfigurationDir);
            if (!oldFile.exists()) {
                return;
            }
            try {
                Files.copy(oldFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.error("Failed to copy old bookmarks {} to new location {}", (Object)oldFile, (Object)file, (Object)e);
                return;
            }
        }
        try (FileReader reader = new FileReader(file);){
            ingredientJsonStrings = IOUtils.readLines((Reader)reader);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load bookmarks from file {}", (Object)file, (Object)e);
            return;
        }
        ArrayList otherIngredientTypes = new ArrayList(registeredIngredients.getIngredientTypes());
        otherIngredientTypes.remove(VanillaTypes.ITEM);
        IIngredientHelper<ItemStack> itemStackHelper = registeredIngredients.getIngredientHelper(VanillaTypes.ITEM);
        for (String ingredientJsonString : ingredientJsonStrings) {
            if (ingredientJsonString.startsWith(MARKER_STACK)) {
                String itemStackAsJson = ingredientJsonString.substring(MARKER_STACK.length());
                try {
                    CompoundTag itemStackAsNbt = TagParser.m_129359_((String)itemStackAsJson);
                    ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemStackAsNbt);
                    if (!itemStack.m_41619_()) {
                        ItemStack normalized = itemStackHelper.normalizeIngredient(itemStack);
                        Optional<ITypedIngredient<ItemStack>> typedIngredient = TypedIngredient.createTyped(registeredIngredients, VanillaTypes.ITEM, normalized);
                        if (typedIngredient.isEmpty()) {
                            LOGGER.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
                            continue;
                        }
                        bookmarkList.addToList(typedIngredient.get(), false);
                        continue;
                    }
                    LOGGER.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
                }
                catch (CommandSyntaxException e) {
                    LOGGER.error("Failed to load bookmarked ItemStack from json string:\n{}", (Object)itemStackAsJson, (Object)e);
                }
                continue;
            }
            if (ingredientJsonString.startsWith(MARKER_OTHER)) {
                String uid = ingredientJsonString.substring(MARKER_OTHER.length());
                Optional<ITypedIngredient<?>> typedIngredient = BookmarkConfig.getNormalizedIngredientByUid(registeredIngredients, otherIngredientTypes, uid);
                if (typedIngredient.isEmpty()) {
                    LOGGER.error("Failed to load unknown bookmarked ingredient:\n{}", (Object)ingredientJsonString);
                    continue;
                }
                bookmarkList.addToList(typedIngredient.get(), false);
                continue;
            }
            LOGGER.error("Failed to load unknown bookmarked ingredient:\n{}", (Object)ingredientJsonString);
        }
        bookmarkList.notifyListenersOfChange();
    }

    private static <T> String getUid(RegisteredIngredients registeredIngredients, ITypedIngredient<T> typedIngredient) {
        IIngredientHelper<T> ingredientHelper = registeredIngredients.getIngredientHelper(typedIngredient.getType());
        return ingredientHelper.getUniqueId(typedIngredient.getIngredient(), UidContext.Ingredient);
    }

    private static Optional<ITypedIngredient<?>> getNormalizedIngredientByUid(RegisteredIngredients registeredIngredients, Collection<IIngredientType<?>> ingredientTypes, String uid) {
        return ingredientTypes.stream().map(t -> BookmarkConfig.getNormalizedIngredientByUid(registeredIngredients, t, uid)).flatMap(Optional::stream).findFirst();
    }

    private static <T> Optional<ITypedIngredient<?>> getNormalizedIngredientByUid(RegisteredIngredients registeredIngredients, IIngredientType<T> ingredientType, String uid) {
        IngredientInfo<T> ingredientInfo = registeredIngredients.getIngredientInfo(ingredientType);
        T ingredient = ingredientInfo.getIngredientByUid(uid);
        return Optional.ofNullable(ingredient).map(i -> {
            IIngredientHelper<Object> ingredientHelper = registeredIngredients.getIngredientHelper(ingredientType);
            return ingredientHelper.normalizeIngredient(i);
        }).flatMap(i -> TypedIngredient.createTyped(registeredIngredients, ingredientType, i));
    }
}

