/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import java.util.List;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.events.RuntimeEventSubscriptions;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.LeftAreaDispatcher;
import mezz.jei.input.MouseUtil;
import mezz.jei.util.LimitedLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LimitedLogger missingBackgroundLogger = new LimitedLogger(LOGGER, Duration.ofHours(1L));
    private final IngredientListOverlay ingredientListOverlay;
    private final GuiScreenHelper guiScreenHelper;
    private final LeftAreaDispatcher leftAreaDispatcher;
    private boolean drawnOnBackground = false;

    public GuiEventHandler(GuiScreenHelper guiScreenHelper, LeftAreaDispatcher leftAreaDispatcher, IngredientListOverlay ingredientListOverlay) {
        this.guiScreenHelper = guiScreenHelper;
        this.leftAreaDispatcher = leftAreaDispatcher;
        this.ingredientListOverlay = ingredientListOverlay;
    }

    public void register(RuntimeEventSubscriptions subscriptions) {
        subscriptions.register(ScreenEvent.InitScreenEvent.Post.class, this::onGuiInit);
        subscriptions.register(ScreenOpenEvent.class, this::onGuiOpen);
        subscriptions.register(ScreenEvent.BackgroundDrawnEvent.class, this::onDrawBackgroundEventPost);
        subscriptions.register(ContainerScreenEvent.DrawForeground.class, this::onDrawForegroundEvent);
        subscriptions.register(ScreenEvent.DrawScreenEvent.Post.class, this::onDrawScreenEventPost);
        subscriptions.register(TickEvent.ClientTickEvent.class, this::onClientTick);
    }

    public void onGuiInit(ScreenEvent.InitScreenEvent.Post event) {
        Screen screen = event.getScreen();
        this.ingredientListOverlay.updateScreen(screen, false);
        this.leftAreaDispatcher.updateScreen(screen, false);
    }

    public void onGuiOpen(ScreenOpenEvent event) {
        Screen screen = event.getScreen();
        this.ingredientListOverlay.updateScreen(screen, false);
        this.leftAreaDispatcher.updateScreen(screen, false);
    }

    public void onDrawBackgroundEventPost(ScreenEvent.BackgroundDrawnEvent event) {
        Screen screen = event.getScreen();
        Minecraft minecraft = screen.getMinecraft();
        boolean exclusionAreasChanged = this.guiScreenHelper.updateGuiExclusionAreas(screen);
        this.ingredientListOverlay.updateScreen(screen, exclusionAreasChanged);
        this.leftAreaDispatcher.updateScreen(screen, exclusionAreasChanged);
        this.drawnOnBackground = true;
        double mouseX = MouseUtil.getX();
        double mouseY = MouseUtil.getY();
        PoseStack poseStack = event.getPoseStack();
        this.ingredientListOverlay.drawScreen(minecraft, poseStack, (int)mouseX, (int)mouseY, minecraft.m_91296_());
        this.leftAreaDispatcher.drawScreen(minecraft, poseStack, (int)mouseX, (int)mouseY, minecraft.m_91296_());
    }

    public void onDrawForegroundEvent(ContainerScreenEvent.DrawForeground event) {
        AbstractContainerScreen screen = event.getContainerScreen();
        Minecraft minecraft = screen.getMinecraft();
        this.ingredientListOverlay.drawOnForeground(minecraft, event.getPoseStack(), screen, event.getMouseX(), event.getMouseY());
    }

    public void onDrawScreenEventPost(ScreenEvent.DrawScreenEvent.Post event) {
        Screen screen = event.getScreen();
        Minecraft minecraft = screen.getMinecraft();
        PoseStack poseStack = event.getPoseStack();
        this.ingredientListOverlay.updateScreen(screen, false);
        this.leftAreaDispatcher.updateScreen(screen, false);
        if (!this.drawnOnBackground) {
            if (screen instanceof AbstractContainerScreen) {
                String guiName = screen.getClass().getName();
                missingBackgroundLogger.log(Level.WARN, guiName, "GUI did not draw the dark background layer behind itself, this may result in display issues: {}", guiName);
            }
            this.ingredientListOverlay.drawScreen(minecraft, poseStack, event.getMouseX(), event.getMouseY(), minecraft.m_91296_());
            this.leftAreaDispatcher.drawScreen(minecraft, poseStack, event.getMouseX(), event.getMouseY(), minecraft.m_91296_());
        }
        this.drawnOnBackground = false;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen;
            this.guiScreenHelper.getGuiClickableArea(guiContainer, event.getMouseX() - guiContainer.getGuiLeft(), event.getMouseY() - guiContainer.getGuiTop()).map(IGuiClickableArea::getTooltipStrings).ifPresent(tooltipStrings -> {
                if (tooltipStrings.isEmpty()) {
                    tooltipStrings = List.of(new TranslatableComponent("jei.tooltip.show.recipes"));
                }
                TooltipRenderer.drawHoveringText(poseStack, tooltipStrings, event.getMouseX(), event.getMouseY());
            });
        }
        this.ingredientListOverlay.drawTooltips(minecraft, poseStack, event.getMouseX(), event.getMouseY());
        this.leftAreaDispatcher.drawTooltips(minecraft, poseStack, event.getMouseX(), event.getMouseY());
    }

    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.ingredientListOverlay.handleTick();
    }
}

