/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.load.registration;

import com.google.common.collect.ImmutableTable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.collect.Table;
import mezz.jei.config.Constants;
import mezz.jei.transfer.BasicRecipeTransferHandler;
import mezz.jei.transfer.BasicRecipeTransferInfo;
import mezz.jei.util.ErrorUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RecipeTransferRegistration
implements IRecipeTransferRegistration {
    private final Table<Class<?>, ResourceLocation, IRecipeTransferHandler<?, ?>> recipeTransferHandlers = Table.hashBasedTable();
    private final IStackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IJeiHelpers jeiHelpers;

    public RecipeTransferRegistration(IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper, IJeiHelpers jeiHelpers) {
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
        this.jeiHelpers = jeiHelpers;
    }

    @Override
    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    @Override
    public IRecipeTransferHandlerHelper getTransferHelper() {
        return this.handlerHelper;
    }

    @Override
    public <C extends AbstractContainerMenu> void addRecipeTransferHandler(Class<C> containerClass, ResourceLocation recipeCategoryUid, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        ErrorUtil.checkNotNull(containerClass, "containerClass");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        BasicRecipeTransferInfo<C, Object> recipeTransferHelper = new BasicRecipeTransferInfo<C, Object>(containerClass, Object.class, recipeCategoryUid, recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount);
        this.addRecipeTransferHandler(recipeTransferHelper);
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(IRecipeTransferInfo<C, R> recipeTransferInfo) {
        ErrorUtil.checkNotNull(recipeTransferInfo, "recipeTransferInfo");
        BasicRecipeTransferHandler<C, R> recipeTransferHandler = new BasicRecipeTransferHandler<C, R>(this.stackHelper, this.handlerHelper, recipeTransferInfo);
        this.addRecipeTransferHandler(recipeTransferHandler, recipeTransferInfo.getRecipeCategoryUid());
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(IRecipeTransferHandler<C, R> recipeTransferHandler, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeTransferHandler, "recipeTransferHandler");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        Class<C> containerClass = recipeTransferHandler.getContainerClass();
        this.recipeTransferHandlers.put(containerClass, recipeCategoryUid, recipeTransferHandler);
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addUniversalRecipeTransferHandler(IRecipeTransferHandler<C, R> recipeTransferHandler) {
        ErrorUtil.checkNotNull(recipeTransferHandler, "recipeTransferHandler");
        Class<C> containerClass = recipeTransferHandler.getContainerClass();
        this.recipeTransferHandlers.put(containerClass, Constants.UNIVERSAL_RECIPE_TRANSFER_UID, recipeTransferHandler);
    }

    public ImmutableTable<Class<?>, ResourceLocation, IRecipeTransferHandler<?, ?>> getRecipeTransferHandlers() {
        return this.recipeTransferHandlers.toImmutable();
    }
}

