/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.textures.Textures;
import mezz.jei.plugins.jei.info.IngredientInfoRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class IngredientInfoRecipeCategory
implements IRecipeCategory<IngredientInfoRecipe> {
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    private static final int lineSpacing = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final Component localizedName;

    public IngredientInfoRecipeCategory(IGuiHelper guiHelper, Textures textures) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        this.icon = textures.getInfoIcon();
        this.slotBackground = guiHelper.getSlotDrawable();
        this.localizedName = new TranslatableComponent("gui.jei.category.itemInformation");
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaRecipeCategoryUid.INFORMATION;
    }

    @Override
    public Class<? extends IngredientInfoRecipe> getRecipeClass() {
        return IngredientInfoRecipe.class;
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void draw(IngredientInfoRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        boolean xPos = false;
        int yPos = this.slotBackground.getHeight() + 4;
        Minecraft minecraft = Minecraft.m_91087_();
        for (FormattedText descriptionLine : recipe.getDescription()) {
            minecraft.f_91062_.m_92877_(poseStack, Language.m_128107_().m_5536_(descriptionLine), (float)xPos, (float)yPos, -16777216);
            Objects.requireNonNull(minecraft.f_91062_);
            yPos += 9 + 2;
        }
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IngredientInfoRecipe recipe, IFocusGroup focuses) {
        int xPos = 72;
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, xPos, 1).setBackground(this.slotBackground, -1, -1);
        IIngredientAcceptor<?> outputSlotBuilder = builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT);
        for (ITypedIngredient<?> typedIngredient : recipe.getIngredients()) {
            IngredientInfoRecipeCategory.addIngredient(typedIngredient, inputSlotBuilder);
            IngredientInfoRecipeCategory.addIngredient(typedIngredient, outputSlotBuilder);
        }
    }

    private static <T> void addIngredient(ITypedIngredient<T> typedIngredient, IIngredientAcceptor<?> slotBuilder) {
        slotBuilder.addIngredient(typedIngredient.getType(), typedIngredient.getIngredient());
    }
}

