/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.config.SearchMode;
import mezz.jei.ingredients.IListElementInfo;
import mezz.jei.search.ISearchStorage;
import mezz.jei.search.suffixtree.GeneralizedSuffixTree;
import org.jetbrains.annotations.Unmodifiable;

public class PrefixInfo {
    public static final PrefixInfo NO_PREFIX = new PrefixInfo('\u0000', () -> SearchMode.ENABLED, i -> List.of(i.getName()), GeneralizedSuffixTree::new);
    private final char prefix;
    private final IModeGetter modeGetter;
    private final IStringsGetter stringsGetter;
    private final Supplier<ISearchStorage<IListElementInfo<?>>> storageSupplier;

    public PrefixInfo(char prefix, IModeGetter modeGetter, IStringsGetter stringsGetter, Supplier<ISearchStorage<IListElementInfo<?>>> storageSupplier) {
        this.prefix = prefix;
        this.modeGetter = modeGetter;
        this.stringsGetter = stringsGetter;
        this.storageSupplier = storageSupplier;
    }

    public char getPrefix() {
        return this.prefix;
    }

    public SearchMode getMode() {
        return this.modeGetter.getMode();
    }

    public ISearchStorage<IListElementInfo<?>> createStorage() {
        return this.storageSupplier.get();
    }

    public @Unmodifiable Collection<String> getStrings(IListElementInfo<?> element) {
        return this.stringsGetter.getStrings(element);
    }

    public String toString() {
        if (this == NO_PREFIX) {
            return "PrefixInfo{NO_PREFIX}";
        }
        return "PrefixInfo{" + this.prefix + "}";
    }

    @FunctionalInterface
    public static interface IModeGetter {
        public SearchMode getMode();
    }

    @FunctionalInterface
    public static interface IStringsGetter {
        public @Unmodifiable Collection<String> getStrings(IListElementInfo<?> var1);
    }
}

