/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import java.util.Collection;
import java.util.Set;
import mezz.jei.config.SearchMode;
import mezz.jei.ingredients.IListElementInfo;
import mezz.jei.search.ISearchStorage;
import mezz.jei.search.ISearchable;
import mezz.jei.search.PrefixInfo;

public class PrefixedSearchable
implements ISearchable<IListElementInfo<?>> {
    private final ISearchStorage<IListElementInfo<?>> searchStorage;
    private final PrefixInfo prefixInfo;

    public PrefixedSearchable(ISearchStorage<IListElementInfo<?>> searchStorage, PrefixInfo prefixInfo) {
        this.searchStorage = searchStorage;
        this.prefixInfo = prefixInfo;
    }

    public ISearchStorage<IListElementInfo<?>> getSearchStorage() {
        return this.searchStorage;
    }

    public Collection<String> getStrings(IListElementInfo<?> element) {
        return this.prefixInfo.getStrings(element);
    }

    @Override
    public SearchMode getMode() {
        return this.prefixInfo.getMode();
    }

    @Override
    public void getSearchResults(String token, Set<IListElementInfo<?>> results) {
        this.searchStorage.getSearchResults(token, results);
    }

    @Override
    public void getAllElements(Set<IListElementInfo<?>> results) {
        this.searchStorage.getAllElements(results);
    }
}

