/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class MultiLineEditBoxWidget
extends AbstractWidget {
    protected final int x1;
    protected final int y1;
    protected final Minecraft minecraft;
    protected final Font font;
    protected final TextFieldHelper pageEdit;
    @Nullable
    private Consumer<Boolean> onOutOfBounds = null;
    @Nonnull
    private String text = "";
    private int frameTick;
    private long lastClickTime;
    private int lastIndex = -1;
    @Nullable
    private DisplayCache displayCache = DisplayCache.EMPTY;

    public MultiLineEditBoxWidget(Minecraft mc, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)new TextComponent("hhhhh"));
        this.minecraft = mc;
        this.font = mc.f_91062_;
        this.x1 = x + width;
        this.y1 = y + height;
        this.pageEdit = new TextFieldHelper(this::getText, this::setText, this::getClipboard, this::setClipboard, this::isStringValid);
        this.clearDisplayCache();
    }

    public void setOutOfBoundResponder(Consumer<Boolean> onOutOfBounds) {
        this.onOutOfBounds = onOutOfBounds;
    }

    public void setState(boolean hasItem, boolean packed) {
        this.m_93692_(false);
        if (packed) {
            this.f_93623_ = false;
        } else {
            this.f_93623_ = hasItem;
            if (!hasItem) {
                this.setText("");
            }
        }
    }

    private boolean isStringValid(String s) {
        if (s != null && ((String)s).length() < 256) {
            if (((String)s).endsWith("\n")) {
                s = (String)s + "-";
            }
            return this.font.m_92920_((String)s, this.f_93618_) <= this.f_93619_;
        }
        return false;
    }

    private void setClipboard(String p_98148_) {
        if (this.minecraft != null) {
            TextFieldHelper.m_95155_((Minecraft)this.minecraft, (String)p_98148_);
        }
    }

    private String getClipboard() {
        return this.minecraft != null ? TextFieldHelper.m_95169_((Minecraft)this.minecraft) : "";
    }

    public void tick() {
        ++this.frameTick;
    }

    public boolean m_5534_(char c, int key) {
        if (this.canConsumeInput() && SharedConstants.m_136188_((char)c)) {
            this.pageEdit.m_95158_(Character.toString(c));
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.m_93696_() && this.m_142518_();
    }

    public boolean m_7933_(int key, int alt, int ctrl) {
        if (this.canConsumeInput() && this.bookKeyPressed(key, alt, ctrl)) {
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    private boolean bookKeyPressed(int key, int alt, int ctrl) {
        if (Screen.m_96634_((int)key)) {
            this.pageEdit.m_95188_();
            return true;
        }
        if (Screen.m_96632_((int)key)) {
            this.pageEdit.m_95178_();
            return true;
        }
        if (Screen.m_96630_((int)key)) {
            this.pageEdit.m_95165_();
            return true;
        }
        if (Screen.m_96628_((int)key)) {
            this.pageEdit.m_95142_();
            return true;
        }
        switch (key) {
            case 257: 
            case 335: {
                int p = this.pageEdit.m_95194_();
                this.pageEdit.m_95158_("\n");
                if (p == this.pageEdit.m_95194_()) {
                    this.callOutOfBounds(false);
                }
                return true;
            }
            case 259: {
                this.pageEdit.m_95189_(-1);
                return true;
            }
            case 261: {
                this.pageEdit.m_95189_(1);
                return true;
            }
            case 262: {
                this.pageEdit.m_95150_(1, Screen.m_96638_());
                return true;
            }
            case 263: {
                this.pageEdit.m_95150_(-1, Screen.m_96638_());
                return true;
            }
            case 264: {
                this.keyDown();
                return true;
            }
            case 265: {
                this.keyUp();
                return true;
            }
            case 268: {
                this.keyHome();
                return true;
            }
            case 269: {
                this.moveCursorToEnd();
                return true;
            }
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.canConsumeInput() && this.f_93624_) {
            if (amount >= 1.0) {
                this.keyUp();
                this.clearDisplayCache();
                return true;
            }
            if (amount <= -1.0) {
                this.keyDown();
                this.clearDisplayCache();
                return true;
            }
        }
        return false;
    }

    private void callOutOfBounds(boolean up) {
        if (this.onOutOfBounds != null) {
            this.onOutOfBounds.accept(up);
        }
    }

    private void keyUp() {
        this.changeLine(-1);
    }

    private void keyDown() {
        this.changeLine(1);
    }

    private void changeLine(int amount) {
        int i = this.pageEdit.m_95194_();
        int j = this.getDisplayCache().changeLine(i, amount);
        this.pageEdit.m_95179_(j, Screen.m_96638_());
        if (i == j) {
            this.callOutOfBounds(amount < 0);
        }
    }

    private void keyHome() {
        int i = this.pageEdit.m_95194_();
        int j = this.getDisplayCache().findLineStart(i);
        this.pageEdit.m_95179_(j, Screen.m_96638_());
    }

    public void moveCursorToEnd() {
        DisplayCache displayCache = this.getDisplayCache();
        int i = this.pageEdit.m_95194_();
        int j = displayCache.findLineEnd(i);
        this.pageEdit.m_95179_(j, Screen.m_96638_());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.clearDisplayCache();
        this.onValueChanged();
    }

    public void onValueChanged() {
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int museY, float partialTicks) {
        if (this.f_93624_) {
            DisplayCache displayCache = this.getDisplayCache();
            for (LineInfo lineInfo : displayCache.lines) {
                this.font.m_92889_(poseStack, lineInfo.asComponent, (float)lineInfo.x, (float)lineInfo.y, -16777216);
            }
            if (this.m_93696_()) {
                this.renderHighlight(displayCache.selection);
                this.renderCursor(poseStack, displayCache.cursor, displayCache.cursorAtEnd);
            }
        }
    }

    private void renderCursor(PoseStack poseStack, Pos2i pos2i, boolean p_98111_) {
        if (this.frameTick / 6 % 2 == 0) {
            pos2i = this.convertLocalToScreen(pos2i);
            if (!p_98111_) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)pos2i.x, (int)(pos2i.y - 1), (int)(pos2i.x + 1), (int)(pos2i.y + 9), (int)-16777216);
            } else {
                this.font.m_92883_(poseStack, "_", (float)pos2i.x, (float)pos2i.y, 0);
            }
        }
    }

    private void renderHighlight(Rect2i[] rect2is) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (Rect2i rect2i : rect2is) {
            int i = rect2i.m_110085_();
            int j = rect2i.m_110086_();
            int k = i + rect2i.m_110090_();
            int l = j + rect2i.m_110091_();
            bufferbuilder.m_5483_((double)i, (double)l, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)k, (double)l, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)k, (double)j, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)i, (double)j, 0.0).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }

    private Pos2i convertScreenToLocal(Pos2i pos2i) {
        return new Pos2i(pos2i.x - this.f_93620_, pos2i.y - this.f_93621_);
    }

    private Pos2i convertLocalToScreen(Pos2i pos2i) {
        return new Pos2i(pos2i.x + this.f_93620_, pos2i.y + this.f_93621_);
    }

    public void m_7435_(SoundManager soundManager) {
    }

    public void m_93692_(boolean b) {
        super.m_93692_(b);
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.m_93692_(true);
    }

    public boolean m_93680_(double mouseX, double mouseY) {
        if (this.m_5953_(mouseX, mouseY)) {
            long i = Util.m_137550_();
            DisplayCache displayCache = this.getDisplayCache();
            int j = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            if (j >= 0) {
                if (j == this.lastIndex && i - this.lastClickTime < 250L) {
                    if (!this.pageEdit.m_95198_()) {
                        this.selectWord(j);
                    } else {
                        this.pageEdit.m_95188_();
                    }
                } else {
                    this.pageEdit.m_95179_(j, Screen.m_96638_());
                }
                this.clearDisplayCache();
            }
            this.lastIndex = j;
            this.lastClickTime = i;
            return true;
        }
        return false;
    }

    private void selectWord(int p_98142_) {
        String s = this.getText();
        this.pageEdit.m_95147_(StringSplitter.m_92355_((String)s, (int)-1, (int)p_98142_, (boolean)false), StringSplitter.m_92355_((String)s, (int)1, (int)p_98142_, (boolean)false));
    }

    public void m_7212_(double mouseX, double mouseY, double dx, double dy) {
        DisplayCache displayCache = this.getDisplayCache();
        int i = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
        this.pageEdit.m_95179_(i, true);
        this.clearDisplayCache();
    }

    protected DisplayCache getDisplayCache() {
        if (this.displayCache == null) {
            this.displayCache = this.rebuildDisplayCache();
        }
        return this.displayCache;
    }

    protected void clearDisplayCache() {
        this.displayCache = null;
    }

    private DisplayCache rebuildDisplayCache() {
        Pos2i pos2i;
        boolean flag;
        String s = this.getText();
        if (s.isEmpty()) {
            return DisplayCache.EMPTY;
        }
        int i = this.pageEdit.m_95194_();
        int j = this.pageEdit.m_95197_();
        IntArrayList intlist = new IntArrayList();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        StringSplitter stringsplitter = this.font.m_92865_();
        stringsplitter.m_92364_(s, this.f_93618_, Style.f_131099_, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$0(mutableint, s, mutableboolean, (IntList)intlist, list, arg_0, arg_1, arg_2));
        int[] toIntArray = intlist.toIntArray();
        boolean bl = flag = i == s.length();
        if (flag && mutableboolean.isTrue()) {
            pos2i = new Pos2i(0, list.size() * 9);
        } else {
            int k = MultiLineEditBoxWidget.findLineFromPos(toIntArray, i);
            int l = this.font.m_92895_(s.substring(toIntArray[k], i));
            pos2i = new Pos2i(l, k * 9);
        }
        ArrayList list1 = Lists.newArrayList();
        if (i != j) {
            int k1;
            int l2 = Math.min(i, j);
            int i1 = Math.max(i, j);
            int j1 = MultiLineEditBoxWidget.findLineFromPos(toIntArray, l2);
            if (j1 == (k1 = MultiLineEditBoxWidget.findLineFromPos(toIntArray, i1))) {
                int l1 = j1 * 9;
                int i2 = toIntArray[j1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i1, l1, i2));
            } else {
                int i3 = j1 + 1 > toIntArray.length ? s.length() : toIntArray[j1 + 1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i3, j1 * 9, toIntArray[j1]));
                for (int j3 = j1 + 1; j3 < k1; ++j3) {
                    int j2 = j3 * 9;
                    String s1 = s.substring(toIntArray[j3], toIntArray[j3 + 1]);
                    int k2 = (int)stringsplitter.m_92353_(s1);
                    list1.add(this.createSelection(new Pos2i(0, j2), new Pos2i(k2, j2 + 9)));
                }
                list1.add(this.createPartialLineSelection(s, stringsplitter, toIntArray[k1], i1, k1 * 9, toIntArray[k1]));
            }
        }
        return new DisplayCache(s, pos2i, flag, toIntArray, list.toArray(new LineInfo[0]), list1.toArray(new Rect2i[0]));
    }

    static int findLineFromPos(int[] p_98150_, int p_98151_) {
        int i = Arrays.binarySearch(p_98150_, p_98151_);
        return i < 0 ? -(i + 2) : i;
    }

    private Rect2i createPartialLineSelection(String p_98120_, StringSplitter p_98121_, int p_98122_, int p_98123_, int p_98124_, int p_98125_) {
        String s = p_98120_.substring(p_98125_, p_98122_);
        String s1 = p_98120_.substring(p_98125_, p_98123_);
        Pos2i pos2i = new Pos2i((int)p_98121_.m_92353_(s), p_98124_);
        Pos2i pos2i1 = new Pos2i((int)p_98121_.m_92353_(s1), p_98124_ + 9);
        return this.createSelection(pos2i, pos2i1);
    }

    private Rect2i createSelection(Pos2i p_98117_, Pos2i p_98118_) {
        Pos2i pos2i = this.convertLocalToScreen(p_98117_);
        Pos2i pos2i1 = this.convertLocalToScreen(p_98118_);
        int i = Math.min(pos2i.x, pos2i1.x);
        int j = Math.max(pos2i.x, pos2i1.x);
        int k = Math.min(pos2i.y, pos2i1.y);
        int l = Math.max(pos2i.y, pos2i1.y);
        return new Rect2i(i, k, j - i, l - k);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    private /* synthetic */ void lambda$rebuildDisplayCache$0(MutableInt mutableint, String s, MutableBoolean mutableboolean, IntList intlist, List list, Style lineInfo, int p_98133_, int p_98134_) {
        int k3 = mutableint.getAndIncrement();
        String s2 = s.substring(p_98133_, p_98134_);
        mutableboolean.setValue(s2.endsWith("\n"));
        String s3 = StringUtils.stripEnd((String)s2, (String)" \n");
        int l3 = k3 * 9;
        Pos2i pos2i = this.convertLocalToScreen(new Pos2i(0, l3));
        intlist.add(p_98133_);
        list.add(new LineInfo(lineInfo, s3, pos2i.x, pos2i.y));
    }

    static class DisplayCache {
        static final DisplayCache EMPTY = new DisplayCache("", new Pos2i(0, 0), true, new int[]{0}, new LineInfo[]{new LineInfo(Style.f_131099_, "", 0, 0)}, new Rect2i[0]);
        private final String fullText;
        final Pos2i cursor;
        final boolean cursorAtEnd;
        private final int[] lineStarts;
        final LineInfo[] lines;
        final Rect2i[] selection;

        public DisplayCache(String p_98201_, Pos2i p_98202_, boolean p_98203_, int[] p_98204_, LineInfo[] p_98205_, Rect2i[] p_98206_) {
            this.fullText = p_98201_;
            this.cursor = p_98202_;
            this.cursorAtEnd = p_98203_;
            this.lineStarts = p_98204_;
            this.lines = p_98205_;
            this.selection = p_98206_;
        }

        public int getIndexAtPosition(Font p_98214_, Pos2i p_98215_) {
            int i = p_98215_.y / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.fullText.length();
            }
            LineInfo lineInfo = this.lines[i];
            return this.lineStarts[i] + p_98214_.m_92865_().m_92360_(lineInfo.contents, p_98215_.x, lineInfo.style);
        }

        public int changeLine(int p_98211_, int p_98212_) {
            int k;
            int i = MultiLineEditBoxWidget.findLineFromPos(this.lineStarts, p_98211_);
            int j = i + p_98212_;
            if (0 <= j && j < this.lineStarts.length) {
                int l = p_98211_ - this.lineStarts[i];
                int i1 = this.lines[j].contents.length();
                k = this.lineStarts[j] + Math.min(l, i1);
            } else {
                k = p_98211_;
            }
            return k;
        }

        public int findLineStart(int p_98209_) {
            int i = MultiLineEditBoxWidget.findLineFromPos(this.lineStarts, p_98209_);
            return this.lineStarts[i];
        }

        public int findLineEnd(int p_98219_) {
            int i = MultiLineEditBoxWidget.findLineFromPos(this.lineStarts, p_98219_);
            return this.lineStarts[i] + this.lines[i].contents.length();
        }
    }

    static class LineInfo {
        final Style style;
        final String contents;
        final Component asComponent;
        final int x;
        final int y;

        public LineInfo(Style style, String contents, int x, int y) {
            this.style = style;
            this.contents = contents;
            this.x = x;
            this.y = y;
            this.asComponent = new TextComponent(contents).m_6270_(style);
        }
    }

    record Pos2i(int x, int y) {
    }
}

