/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.entities.FallingAshEntity;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class AshLayerBlock
extends FallingBlock {
    private static final int MAX_LAYERS = 8;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[9];
    public static final int GRASS_SPREAD_WIDTH = 3;

    public AshLayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult pHit, Projectile projectile) {
        ThrownPotion potion;
        BlockPos pos = pHit.m_82425_();
        if (projectile instanceof ThrownPotion && PotionUtils.m_43579_((ItemStack)(potion = (ThrownPotion)projectile).m_7846_()) == Potions.f_43599_) {
            boolean flag;
            Entity entity2 = projectile.m_37282_();
            boolean bl = flag = entity2 == null || entity2 instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity2);
            if (flag) {
                this.removeOneLayer(state, pos, level);
            }
        }
    }

    public int m_6248_(BlockState state, BlockGetter reader, BlockPos pos) {
        return 0x9A9090;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() != oldState.m_60734_()) {
            worldIn.m_186460_(pos, (Block)this, this.m_7198_());
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        EntityCollisionContext c;
        Entity e;
        if (pContext instanceof EntityCollisionContext && (e = (c = (EntityCollisionContext)pContext).m_193113_()) instanceof LivingEntity) {
            return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS) - 1];
        }
        return this.m_5940_(pState, pLevel, pPos, pContext);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType pathType) {
        if (pathType == PathComputationType.LAND) {
            return (Integer)state.m_61143_((Property)LAYERS) <= 4;
        }
        return false;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos otherPos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            BlockPos pos = currentPos.m_7494_();
            BlockState state1 = world.m_8055_(pos);
            while (state1.m_60713_((Block)this)) {
                serverLevel.m_186460_(pos, (Block)this, this.m_7198_());
                pos = pos.m_7494_();
                state1 = serverLevel.m_8055_(pos);
            }
        }
        return super.m_7417_(state, direction, facingState, world, currentPos, otherPos);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random pRand) {
        BlockState below = level.m_8055_(pos.m_7495_());
        if ((FallingAshEntity.isFree(below) || this.hasIncompleteAshPileBelow(below)) && pos.m_123342_() >= level.m_141937_()) {
            while (state.m_60713_((Block)this)) {
                FallingAshEntity fallingblockentity = new FallingAshEntity((Level)level, pos, state);
                this.m_6788_(fallingblockentity);
                level.m_7967_((Entity)fallingblockentity);
                pos = pos.m_7494_();
                state = level.m_8055_(pos);
            }
        }
    }

    private boolean hasIncompleteAshPileBelow(BlockState state) {
        return state.m_60713_((Block)this) && (Integer)state.m_61143_((Property)LAYERS) != 8;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            int i = (Integer)blockstate.m_61143_((Property)LAYERS);
            return (BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.m_5573_(context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LAYERS});
    }

    public void m_7455_(BlockState pState, ServerLevel level, BlockPos pPos, Random pRandom) {
        if (ServerConfigs.cached.ASH_RAIN && level.m_46758_(pPos.m_7494_()) && level.f_46441_.nextInt(4) == 0) {
            this.removeOneLayer(pState, pPos, (Level)level);
        }
    }

    public void m_141997_(BlockState pState, Level level, BlockPos pPos, Biome.Precipitation pPrecipitation) {
        super.m_141997_(pState, level, pPos, pPrecipitation);
        if (ServerConfigs.cached.ASH_RAIN && level.f_46441_.nextInt(2) == 0) {
            this.removeOneLayer(pState, pPos, level);
        }
    }

    private void removeOneLayer(BlockState state, BlockPos pos, Level level) {
        int levels = (Integer)state.m_61143_((Property)LAYERS);
        if (levels > 1) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(levels - 1)));
        } else {
            level.m_7471_(pos, false);
        }
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        int i = (Integer)pState.m_61143_((Property)LAYERS);
        if (pUseContext.m_43722_().m_150930_(this.m_5456_()) && i < 8) {
            return true;
        }
        return i == 1;
    }

    public static boolean tryConvertToAsh(Level level, BlockPos pPos) {
        if (ServerConfigs.cached.ASH_BURN) {
            int layers;
            BlockState state = level.m_8055_(pPos);
            Item i = state.m_60734_().m_5456_();
            int count = ForgeHooks.getBurnTime((ItemStack)i.m_7968_(), null) / 100;
            if (ItemTags.f_13181_.m_8110_((Object)i)) {
                count += 2;
            }
            if (count > 0 && (layers = Mth.m_14045_((int)level.f_46441_.nextInt(count), (int)1, (int)8)) != 0) {
                ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)ModRegistry.ASH_PARTICLE.get()), (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 10 + layers, 0.5, 0.5, 0.5, 0.0);
                return level.m_7731_(pPos, (BlockState)((Block)ModRegistry.ASH_BLOCK.get()).m_49966_().m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layers)), 3);
            }
        }
        return false;
    }

    private void addParticle(Entity entity2, BlockPos pos, Level level, int layers, float upSpeed) {
        level.m_7106_((ParticleOptions)ModRegistry.ASH_PARTICLE.get(), entity2.m_20185_(), (double)((float)pos.m_123342_() + (float)layers * 0.125f), entity2.m_20189_(), (double)(Mth.m_144924_((Random)level.f_46441_, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)upSpeed, (double)(Mth.m_144924_((Random)level.f_46441_, (float)-1.0f, (float)1.0f) * 0.083333336f));
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity2) {
        if (level.f_46443_ && level.f_46441_.nextInt(8) == 0 && (entity2.f_19790_ != entity2.m_20185_() || entity2.f_19792_ != entity2.m_20189_())) {
            this.addParticle(entity2, pos, level, (Integer)state.m_61143_((Property)LAYERS), 0.05f);
        }
        super.m_141947_(level, pos, state, entity2);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity2, float height) {
        int layers = (Integer)state.m_61143_((Property)LAYERS);
        entity2.m_142535_(height, layers > 2 ? 0.3f : 1.0f, DamageSource.f_19315_);
        if (level.f_46443_) {
            int i = 0;
            while ((double)i < Math.min(12.0, (double)height * 1.4)) {
                this.addParticle(entity2, pos, level, layers, 0.12f);
                ++i;
            }
        }
    }

    public static boolean applyBonemeal(ItemStack stack, Level level, BlockPos pos, Player player) {
        BonemealableBlock bonemealableblock;
        BlockState blockstate = level.m_8055_(pos);
        Block block2 = blockstate.m_60734_();
        if (block2 instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)block2).m_7370_((BlockGetter)level, pos, blockstate, level.f_46443_)) {
            if (level instanceof ServerLevel) {
                if (bonemealableblock.m_5491_(level, level.f_46441_, pos, blockstate)) {
                    bonemealableblock.m_7719_((ServerLevel)level, level.f_46441_, pos, blockstate);
                }
                stack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public void performBonemeal(ServerLevel level, Random random, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = Blocks.f_50034_.m_49966_();
        block0: for (int i = 0; i < 128; ++i) {
            PlacedFeature placedfeature;
            BlockPos pos1 = blockpos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.m_8055_((pos1 = pos1.m_142082_(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).m_7495_()).m_60713_((Block)this) || level.m_8055_(pos1).m_60838_((BlockGetter)level, pos1)) continue block0;
            }
            BlockState state1 = level.m_8055_(pos1);
            if (!state1.m_60795_()) continue;
            if (random.nextInt(8) == 0) {
                List list = level.m_46857_(pos1).m_47536_().m_47815_();
                if (list.isEmpty()) continue;
                placedfeature = (PlacedFeature)((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).m_65397_()).f_191304_().get();
            } else {
                placedfeature = VegetationPlacements.f_195459_;
            }
            placedfeature.m_191782_((WorldGenLevel)level, level.m_7726_().m_8481_(), random, pos1);
        }
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER, l -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(l * 2), (double)16.0));
        AshLayerBlock.SHAPE_BY_LAYER[0] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.1f, (double)16.0);
    }
}

