/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import java.util.Locale;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GlobeBlock;
import net.mehvahdjukaar.supplementaries.common.utils.SpecialPlayers;
import net.mehvahdjukaar.supplementaries.common.utils.Textures;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GlobeBlockTile
extends BlockEntity
implements Nameable {
    private final boolean sepia;
    private Component customName;
    public float yaw = 0.0f;
    public float prevYaw = 0.0f;
    public int face = 0;
    public boolean sheared = false;
    public Pair<GlobeModel, @Nullable ResourceLocation> renderData = Pair.of((Object)((Object)GlobeModel.GLOBE), null);

    public GlobeBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.GLOBE_TILE.get(), pos, state);
        this.sepia = state.m_60713_((Block)ModRegistry.GLOBE_SEPIA.get());
    }

    public boolean isSepia() {
        return this.sepia;
    }

    public void setCustomName(Component name) {
        this.customName = name;
        this.updateTexture();
    }

    private void updateTexture() {
        this.renderData = this.m_8077_() ? GlobeType.getGlobeTexture(this.m_7770_().getString()) : Pair.of((Object)((Object)GlobeModel.GLOBE), null);
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public Component getDefaultName() {
        return new TranslatableComponent("block.supplementaries.globe");
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("CustomName", 8)) {
            this.setCustomName((Component)Component.Serializer.m_130701_((String)compound.m_128461_("CustomName")));
        }
        this.face = compound.m_128451_("Face");
        this.yaw = compound.m_128457_("Yaw");
        this.sheared = compound.m_128471_("Sheared");
        super.m_142466_(compound);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        tag.m_128405_("Face", this.face);
        tag.m_128350_("Yaw", this.yaw);
        tag.m_128379_("Sheared", this.sheared);
    }

    public void spin() {
        int spin = 360;
        int inc = 90;
        this.face = (this.face - inc) % 360;
        this.yaw = this.yaw + (float)spin + (float)inc;
        this.prevYaw = this.prevYaw + (float)spin + (float)inc;
        this.m_6596_();
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.spin();
            return true;
        }
        return super.m_7531_(id, type);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, GlobeBlockTile tile) {
        tile.prevYaw = tile.yaw;
        if (tile.yaw != 0.0f) {
            if (tile.yaw < 0.0f) {
                tile.yaw = 0.0f;
                pLevel.m_46717_(pPos, pState.m_60734_());
            } else {
                tile.yaw = tile.yaw * 0.94f - 0.7f;
            }
        }
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)GlobeBlock.FACING);
    }

    public static enum GlobeModel {
        GLOBE,
        FLAT,
        SNOW,
        SHEARED;

    }

    public static enum GlobeType {
        FLAT(new String[]{"flat", "flat earth"}, new TranslatableComponent("globe.supplementaries.flat"), Textures.GLOBE_FLAT_TEXTURE),
        MOON(new String[]{"moon", "luna", "selene", "cynthia"}, new TranslatableComponent("globe.supplementaries.moon"), Textures.GLOBE_MOON_TEXTURE),
        EARTH(new String[]{"earth", "terra", "gaia", "gaea", "tierra", "tellus", "terre"}, new TranslatableComponent("globe.supplementaries.earth"), Textures.GLOBE_TEXTURE),
        SUN(new String[]{"sun", "sol", "helios"}, new TranslatableComponent("globe.supplementaries.sun"), Textures.GLOBE_SUN_TEXTURE);

        public final String[] keyWords;
        public final TranslatableComponent transKeyWord;
        public final ResourceLocation texture;

        private GlobeType(String[] key, TranslatableComponent tr, ResourceLocation res) {
            this.keyWords = key;
            this.transKeyWord = tr;
            this.texture = res;
        }

        public static Pair<GlobeModel, ResourceLocation> getGlobeTexture(String text) {
            GlobeModel model = GlobeModel.GLOBE;
            String name = text.toLowerCase(Locale.ROOT);
            ResourceLocation r = SpecialPlayers.GLOBES.get(name);
            if (r != null) {
                if (r.m_135815_().contains("globe_wais")) {
                    model = GlobeModel.SNOW;
                }
                return Pair.of((Object)((Object)model), (Object)r);
            }
            for (GlobeType n : GlobeType.values()) {
                if (n.keyWords == null) continue;
                if (n.transKeyWord != null && !n.transKeyWord.getString().equals("") && name.equals(n.transKeyWord.getString().toLowerCase(Locale.ROOT))) {
                    if (n == FLAT) {
                        model = GlobeModel.FLAT;
                    }
                    return Pair.of((Object)((Object)model), (Object)n.texture);
                }
                for (String s : n.keyWords) {
                    if (s.equals("") || !name.equals(s)) continue;
                    if (n == FLAT) {
                        model = GlobeModel.FLAT;
                    }
                    return Pair.of((Object)((Object)model), (Object)n.texture);
                }
            }
            return Pair.of((Object)((Object)GlobeModel.GLOBE), null);
        }
    }
}

