/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import java.util.Random;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.entities.ImprovedProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.common.utils.ModTags;
import net.mehvahdjukaar.supplementaries.common.world.explosion.BombExplosion;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.RegistryObject;

public class BombEntity
extends ImprovedProjectileEntity
implements IEntityAdditionalSpawnData {
    private BombType type;
    private boolean active = true;
    private int changeTimer = -1;
    private boolean superCharged = false;

    public BombEntity(EntityType<? extends BombEntity> type, Level world) {
        super(type, world);
        this.maxAge = 200;
    }

    public BombEntity(Level worldIn, LivingEntity throwerIn, BombType type) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModRegistry.BOMB.get()), throwerIn, worldIn);
        this.type = type;
        this.maxAge = 200;
    }

    public BombEntity(Level worldIn, double x, double y, double z, BombType type) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModRegistry.BOMB.get()), x, y, z, worldIn);
        this.type = type;
        this.maxAge = 200;
    }

    public BombEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModRegistry.BOMB.get()), world);
        this.maxAge = 200;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Active", this.active);
        compound.m_128405_("Type", this.type.ordinal());
        compound.m_128405_("Timer", this.changeTimer);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.active = compound.m_128471_("Active");
        this.type = BombType.values()[compound.m_128451_("Type")];
        this.changeTimer = compound.m_128451_("Timer");
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.type = (BombType)buffer.m_130066_(BombType.class);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.type);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item m_7881_() {
        return (Item)ModRegistry.BOMB_ITEM_ON.get();
    }

    public ItemStack m_7846_() {
        return this.type.getDisplayStack(this.active);
    }

    private void spawnBreakParticles() {
        for (int i = 0; i < 8; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ModRegistry.BOMB_ITEM.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void m_7822_(byte id) {
        switch (id) {
            default: {
                super.m_7822_(id);
                break;
            }
            case 3: {
                this.spawnBreakParticles();
                break;
            }
            case 10: {
                this.spawnBreakParticles();
                if (CommonUtil.FESTIVITY.isBirthday()) {
                    this.spawnParticleInASphere((ParticleOptions)ModRegistry.CONFETTI_PARTICLE.get(), 55, 0.3f);
                } else {
                    this.f_19853_.m_7106_((ParticleOptions)ModRegistry.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), (double)this.type.getRadius(), 0.0, 0.0);
                }
                this.type.spawnExtraParticles(this);
                break;
            }
            case 68: {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 67: {
                Random random = this.f_19853_.m_5822_();
                for (int i = 0; i < 10; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + 0.25 - (double)(random.nextFloat() * 0.5f), this.m_20186_() + (double)0.45f - (double)(random.nextFloat() * 0.5f), this.m_20189_() + 0.25 - (double)(random.nextFloat() * 0.5f), 0.0, 0.005, 0.0);
                }
                this.active = false;
            }
        }
    }

    private void spawnParticleInASphere(ParticleOptions type, int amount, float speed) {
        double d = Math.PI * 2 / (double)amount;
        float d22 = 0.0f;
        while ((double)d22 < Math.PI * 2) {
            Vec3 v = new Vec3((double)speed, 0.0, 0.0);
            v = v.m_82524_(d22 + this.f_19796_.nextFloat() * 0.3f);
            v = v.m_82535_((float)((double)this.f_19796_.nextFloat() * Math.PI));
            this.f_19853_.m_7106_(type, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), v.f_82479_, v.f_82480_, v.f_82481_);
            d22 = (float)((double)d22 + d);
        }
    }

    private double r() {
        return this.f_19796_.nextGaussian() * 0.05;
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return super.hasReachedEndOfLife() || this.changeTimer == 0;
    }

    @Override
    public void m_8119_() {
        if (this.changeTimer > 0) {
            --this.changeTimer;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 0.0, 0.0, 0.0);
        }
        if (this.active && this.m_20069_() && this.type != BombType.BLUE) {
            this.turnOff();
        }
        super.m_8119_();
    }

    @Override
    public void spawnTrailParticles(Vec3 currentPos, Vec3 newPos) {
        if (this.active && !this.f_19803_) {
            double x = currentPos.f_82479_;
            double y = currentPos.f_82480_;
            double z = currentPos.f_82481_;
            double dx = newPos.f_82479_ - x;
            double dy = newPos.f_82480_ - y;
            double dz = newPos.f_82481_ - z;
            int s = 4;
            for (int i = 0; i < s; ++i) {
                double j = (double)i / (double)s;
                this.f_19853_.m_7106_((ParticleOptions)ModRegistry.BOMB_SMOKE_PARTICLE.get(), x + dx * j, 0.5 + y + dy * j, z + dz * j, 0.0, 0.02, 0.0);
            }
        }
    }

    public static boolean canBreakBlock(BlockState state, BombType type) {
        return switch (type.breakMode()) {
            default -> false;
            case BreakingMode.ALL -> true;
            case BreakingMode.WEAK -> state.m_60722_((Fluid)Fluids.f_76193_) || state.m_60620_(ModTags.BOMB_BREAKABLE) || state.m_60734_() instanceof TntBlock;
        };
    }

    protected void m_5790_(EntityHitResult hit) {
        super.m_5790_(hit);
        hit.m_82443_().m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), 1.0f);
        if (hit.m_82443_() instanceof LargeFireball) {
            this.superCharged = true;
            hit.m_82443_().m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void turnOff() {
        if (!this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)67);
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f, 1.5f);
        }
        this.active = false;
    }

    public void m_6123_(Player entityIn) {
        if (!this.f_19853_.f_46443_ && !this.active && entityIn.m_150109_().m_36054_(this.getItemStack())) {
            entityIn.m_7938_((Entity)this, 1);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private ItemStack getItemStack() {
        return new ItemStack((ItemLike)ModRegistry.BOMB_ITEM.get());
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        Vec3 vector3d = hit.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vector3d);
        Vec3 vector3d1 = vector3d.m_82541_().m_82490_((double)this.m_7139_());
        this.m_20343_(this.m_20185_() - vector3d1.f_82479_, this.m_20186_() - vector3d1.f_82480_, this.m_20189_() - vector3d1.f_82481_);
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_) {
            boolean isInstantlyActivated = this.type.isInstantlyActivated();
            if (!isInstantlyActivated && this.changeTimer == -1) {
                this.changeTimer = 10;
                this.f_19853_.m_7605_((Entity)this, (byte)68);
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, SoundSource.NEUTRAL, 1.5f, 1.3f);
            }
            if (!this.m_146910_() && (isInstantlyActivated || this.superCharged)) {
                this.reachedEndOfLife();
            }
        }
    }

    protected void m_37283_() {
    }

    @Override
    public void reachedEndOfLife() {
        if (this.active) {
            this.createExplosion();
            this.f_19853_.m_7605_((Entity)this, (byte)10);
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12198_, SoundSource.NEUTRAL, 1.5f, 1.5f);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    private void createExplosion() {
        boolean breaks;
        boolean bl = breaks = this.m_37282_() instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.m_37282_());
        if (this.superCharged) {
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0f, breaks, breaks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
        }
        BombExplosion explosion = new BombExplosion(this.f_19853_, (Entity)this, null, new ExplosionDamageCalculator(){

            public boolean m_6714_(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
                return BombEntity.canBreakBlock(state, BombEntity.this.type);
            }
        }, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), this.type.getRadius(), this.type, breaks ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE);
        explosion.m_46061_();
        explosion.doFinalizeExplosion();
    }

    public static enum BombType {
        NORMAL(ModRegistry.BOMB_ITEM, ModRegistry.BOMB_ITEM_ON),
        BLUE(ModRegistry.BOMB_BLUE_ITEM, ModRegistry.BOMB_BLUE_ITEM_ON),
        SPIKY(ModRegistry.BOMB_SPIKY_ITEM, ModRegistry.BOMB_SPIKY_ITEM_ON);

        public RegistryObject<Item> item;
        public RegistryObject<Item> item_on;

        private BombType(RegistryObject<Item> item2, RegistryObject<Item> item_on) {
            this.item = item2;
            this.item_on = item_on;
        }

        public ItemStack getDisplayStack(boolean active) {
            return ((Item)(active ? this.item_on : this.item).get()).m_7968_();
        }

        public float getRadius() {
            return this == BLUE ? ServerConfigs.cached.BOMB_BLUE_RADIUS : ServerConfigs.cached.BOMB_RADIUS;
        }

        public BreakingMode breakMode() {
            return this == BLUE ? ServerConfigs.cached.BOMB_BLUE_BREAKS : ServerConfigs.cached.BOMB_BREAKS;
        }

        public float volume() {
            return this == BLUE ? 5.0f : 3.0f;
        }

        public void applyStatusEffects(LivingEntity entity2, double distSq) {
            switch (this) {
                case BLUE: {
                    entity2.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 600));
                    entity2.m_20254_(10);
                    break;
                }
            }
        }

        public boolean isInstantlyActivated() {
            return this != BLUE;
        }

        public void spawnExtraParticles(BombEntity bomb) {
            switch (this) {
                case BLUE: {
                    bomb.spawnParticleInASphere((ParticleOptions)ParticleTypes.f_123744_, 40, 0.6f);
                    break;
                }
                case SPIKY: {
                    ParticleType<?> particle2 = CompatObjects.SHARPNEL.get();
                    if (particle2 instanceof ParticleOptions) {
                        ParticleOptions p = (ParticleOptions)particle2;
                        for (int i = 0; i < 80; ++i) {
                            float dx = (float)(bomb.f_19796_.nextGaussian() * 2.0);
                            float dy = (float)(bomb.f_19796_.nextGaussian() * 2.0);
                            float dz = (float)(bomb.f_19796_.nextGaussian() * 2.0);
                            bomb.f_19853_.m_7106_(p, bomb.m_20185_(), bomb.m_20186_() + 1.0, bomb.m_20189_(), (double)dx, (double)dy, (double)dz);
                        }
                        break;
                    }
                    bomb.spawnParticleInASphere((ParticleOptions)ParticleTypes.f_123797_, 100, 5.0f);
                }
            }
        }

        public void afterExploded(BombExplosion exp, Level level) {
            if (this == SPIKY) {
                Vec3 pos = exp.getPosition();
                Entity e = exp.getExploder();
                if (e == null) {
                    return;
                }
                for (Entity entity2 : level.m_45933_(e, new AABB(pos.f_82479_ - 30.0, pos.f_82480_ - 4.0, pos.f_82481_ - 30.0, pos.f_82479_ + 30.0, pos.f_82480_ + 4.0, pos.f_82481_ + 30.0))) {
                    int random = (int)(Math.random() * 100.0);
                    boolean shouldPoison = false;
                    if (entity2.m_20280_(e) <= 16.0) {
                        shouldPoison = true;
                    } else if (entity2.m_20280_(e) <= 64.0) {
                        if (random < 60) {
                            shouldPoison = true;
                        }
                    } else if (entity2.m_20280_(e) <= 225.0) {
                        if (random < 30) {
                            shouldPoison = true;
                        }
                    } else if (entity2.m_20280_(e) <= 900.0 && random < 5) {
                        shouldPoison = true;
                    }
                    if (!shouldPoison || !(entity2 instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity2;
                    livingEntity.m_6469_(DamageSource.f_19319_, 2.0f);
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 130));
                    MobEffect effect = CompatObjects.STUNNED_EFFECT.get();
                    if (effect == null) continue;
                    livingEntity.m_7292_(new MobEffectInstance(effect, 400));
                }
            }
        }
    }

    public static enum BreakingMode {
        ALL,
        WEAK,
        NONE;

    }
}

