/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.mehvahdjukaar.selene.map.MapDecorationHandler;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.configs.ConfigHandler;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.world.data.map.CMDreg;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.OceanMonumentFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WoodlandMansionFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class AdventurerMapsHandler {
    private static final int SEARCH_RADIUS = 100;
    private static final List<TradeData> CUSTOM_MAPS_TRADES = new ArrayList<TradeData>();
    private static final Map<StructureFeature<?>, Pair<CustomDecorationType<?, ?>, Integer>> DEFAULT_STRUCTURE_MARKERS = new HashMap();
    private static final List<StructureFeature<?>> RANDOM_MAP_POOL = Arrays.asList(StructureFeature.f_67020_, StructureFeature.f_67019_, StructureFeature.f_67021_, StructureFeature.f_67030_, StructureFeature.f_67016_, StructureFeature.f_67017_, StructureFeature.f_67013_, StructureFeature.f_67014_, StructureFeature.f_67024_, StructureFeature.f_67018_, StructureFeature.f_67026_);

    private static CustomDecorationType<?, ?> getVanillaMarker(StructureFeature<?> structure) {
        CustomDecorationType type = (CustomDecorationType)DEFAULT_STRUCTURE_MARKERS.get(structure).getLeft();
        if (type == null) {
            type = MapDecorationHandler.GENERIC_STRUCTURE_TYPE;
        }
        return type;
    }

    private static int getVanillaColor(StructureFeature<?> structure) {
        if (DEFAULT_STRUCTURE_MARKERS.containsKey(structure)) {
            return (Integer)DEFAULT_STRUCTURE_MARKERS.get(structure).getRight();
        }
        return -1;
    }

    public static void loadCustomTrades() {
        if (!CUSTOM_MAPS_TRADES.isEmpty()) {
            return;
        }
        try {
            List<? extends List<String>> tradeData = ConfigHandler.safeGetListString(ServerConfigs.SERVER_SPEC, ServerConfigs.tweaks.CUSTOM_ADVENTURER_MAPS_TRADES);
            for (List<String> list : tradeData) {
                int s = list.size();
                if (s <= 0) continue;
                try {
                    String res = list.get(0);
                    if (res.isEmpty()) continue;
                    ResourceLocation structure = new ResourceLocation(res);
                    int level = 2;
                    int minPrice = 7;
                    int maxPrice = 13;
                    String mapName = null;
                    int mapColor = 0xFFFFFF;
                    ResourceLocation marker = null;
                    if (s > 1) {
                        level = Integer.parseInt(list.get(1));
                    }
                    if (level < 1 || level > 5) {
                        Supplementaries.LOGGER.warn("skipping configs 'custom_adventurer_maps' (" + list + "): invalid level, must be between 1 and 5");
                        continue;
                    }
                    if (s > 2) {
                        minPrice = Integer.parseInt(list.get(2));
                    }
                    if (s > 3) {
                        maxPrice = Integer.parseInt(list.get(3));
                    }
                    if (s > 4) {
                        mapName = list.get(4);
                    }
                    if (s > 5) {
                        mapColor = Integer.parseInt(list.get(5).replace("0x", ""), 16);
                    }
                    if (s > 6) {
                        marker = new ResourceLocation(list.get(6));
                    }
                    CUSTOM_MAPS_TRADES.add(new TradeData(structure, level, minPrice, maxPrice, mapName, mapColor, marker));
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.warn("wrong formatting for configs 'custom_adventurer_maps'(" + list + "), skipping it :" + e);
                }
            }
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("failed to parse config 'custom_adventurer_maps', skipping them.");
        }
    }

    public static void addTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35588_) {
            Int2ObjectMap trades = event.getTrades();
            for (TradeData data : CUSTOM_MAPS_TRADES) {
                if (data == null) continue;
                try {
                    ((List)trades.get(data.level)).add(new AdventureMapTrade(data));
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.warn("failed to load custom adventurer map trade map for structure " + data.structure.toString());
                }
            }
            if (((Boolean)ServerConfigs.tweaks.RANDOM_ADVENTURER_MAPS.get()).booleanValue()) {
                ((List)trades.get(2)).add(new RandomAdventureMapTrade());
            }
        }
    }

    public static ItemStack createStructureMap(Level world, BlockPos pos, ResourceLocation structureName, @Nullable String mapName, int mapColor, @Nullable ResourceLocation mapMarker) {
        StructureFeature structure = (StructureFeature)ForgeRegistries.STRUCTURE_FEATURES.getValue(structureName);
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (structure != null) {
                BlockPos toPos = serverLevel.m_8717_(structure, pos, 100, true);
                if (toPos == null) {
                    return ItemStack.f_41583_;
                }
                ItemStack stack = MapItem.m_42886_((Level)world, (int)toPos.m_123341_(), (int)toPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverLevel, (ItemStack)stack);
                if (structure instanceof OceanMonumentFeature) {
                    MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.MONUMENT);
                } else if (structure instanceof WoodlandMansionFeature) {
                    MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.MANSION);
                } else {
                    int color;
                    int n = color = mapColor == 0xFFFFFF ? AdventurerMapsHandler.getVanillaColor(structure) : mapColor;
                    if (mapMarker == null) {
                        MapDecorationHandler.addTargetDecoration((ItemStack)stack, (BlockPos)toPos, AdventurerMapsHandler.getVanillaMarker(structure), (int)color);
                    } else {
                        MapDecorationHandler.addTargetDecoration((ItemStack)stack, (BlockPos)toPos, (ResourceLocation)mapMarker, (int)color);
                    }
                }
                TranslatableComponent name = new TranslatableComponent((String)(mapName == null ? "filled_map." + structure.m_67098_().toLowerCase(Locale.ROOT) : mapName));
                stack.m_41714_((Component)name);
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    static {
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67020_, Pair.of(CMDreg.SHIPWRECK_TYPE, (Object)3416079));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67018_, Pair.of(CMDreg.IGLOO_TYPE, (Object)10075586));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67019_, Pair.of(CMDreg.RUINED_PORTAL_TYPE, (Object)6238389));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67028_, Pair.of(CMDreg.VILLAGE_TYPE, (Object)12224341));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67024_, Pair.of(CMDreg.OCEAN_RUIN_TYPE, (Object)3828045));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67013_, Pair.of(CMDreg.PILLAGER_OUTPOST_TYPE, (Object)0x1F1100));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67017_, Pair.of(CMDreg.DESERT_PYRAMID_TYPE, (Object)8416575));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67016_, Pair.of(CMDreg.JUNGLE_TEMPLE_TYPE, (Object)5400120));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67030_, Pair.of(CMDreg.BASTION_TYPE, (Object)2894127));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67026_, Pair.of(CMDreg.END_CITY_TYPE, (Object)10253227));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67021_, Pair.of(CMDreg.SWAMP_HUT_TYPE, (Object)1786143));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67025_, Pair.of(CMDreg.NETHER_FORTRESS, (Object)3934219));
        DEFAULT_STRUCTURE_MARKERS.put(StructureFeature.f_67014_, Pair.of(CMDreg.MINESHAFT_TYPE, (Object)0x808080));
    }

    private record TradeData(ResourceLocation structure, int level, int minPrice, int maxPrice, @Nullable String mapName, int mapColor, @Nullable ResourceLocation marker) {
    }

    private static class AdventureMapTrade
    implements VillagerTrades.ItemListing {
        public final TradeData tradeData;

        private AdventureMapTrade(TradeData data) {
            this.tradeData = data;
        }

        public MerchantOffer m_5670_(@Nonnull Entity entity2, @Nonnull Random random) {
            int i = Math.max(1, random.nextInt(Math.max(1, this.tradeData.maxPrice - this.tradeData.minPrice)) + this.tradeData.minPrice);
            ItemStack itemstack = AdventurerMapsHandler.createStructureMap(entity2.f_19853_, entity2.m_142538_(), this.tradeData.structure, this.tradeData.mapName, this.tradeData.mapColor, this.tradeData.marker);
            if (itemstack.m_41619_()) {
                return null;
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, i), new ItemStack((ItemLike)Items.f_42522_), itemstack, 12, Math.max(1, 5 * (this.tradeData.level - 1)), 0.2f);
        }
    }

    private static class RandomAdventureMapTrade
    implements VillagerTrades.ItemListing {
        private RandomAdventureMapTrade() {
        }

        public MerchantOffer m_5670_(@Nonnull Entity entity2, @Nonnull Random random) {
            int maxPrice = 13;
            int minPrice = 7;
            int level = 2;
            int i = random.nextInt(maxPrice - minPrice + 1) + minPrice;
            ItemStack itemstack = this.createMap(entity2.f_19853_, entity2.m_142538_());
            if (itemstack.m_41619_()) {
                return null;
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, i), new ItemStack((ItemLike)Items.f_42522_), itemstack, 12, 5, 0.2f);
        }

        private ItemStack createMap(Level world, BlockPos pos) {
            if (world instanceof ServerLevel) {
                StructureFeature<?> structure;
                BlockPos toPos;
                ServerLevel serverWorld = (ServerLevel)world;
                if (!serverWorld.m_142572_().m_129910_().m_5961_().m_64657_()) {
                    return ItemStack.f_41583_;
                }
                List<StructureFeature<?>> pool = RANDOM_MAP_POOL;
                int size = pool.size();
                if (size > 0 && (toPos = serverWorld.m_8717_(structure = pool.get(serverWorld.f_46441_.nextInt(size)), pos, 100, true)) != null) {
                    ItemStack stack = MapItem.m_42886_((Level)world, (int)toPos.m_123341_(), (int)toPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                    MapItem.m_42850_((ServerLevel)serverWorld, (ItemStack)stack);
                    MapDecorationHandler.addTargetDecoration((ItemStack)stack, (BlockPos)toPos, AdventurerMapsHandler.getVanillaMarker(structure), (int)7869722);
                    stack.m_41714_((Component)new TranslatableComponent("filled_map.adventure"));
                    return stack;
                }
            }
            return ItemStack.f_41583_;
        }
    }
}

