/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SyncConfigsPacket {
    private final byte[] configData;

    public SyncConfigsPacket(FriendlyByteBuf buf) {
        this.configData = buf.m_130052_();
    }

    public SyncConfigsPacket(byte[] configFileData) {
        this.configData = configFileData;
    }

    public static void buffer(SyncConfigsPacket message, FriendlyByteBuf buf) {
        buf.m_130087_(message.configData);
    }

    public static void handler(SyncConfigsPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
                return;
            }
            ServerConfigs.SERVER_SPEC.setConfig((CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(message.configData)));
            ServerConfigs.cached.refresh();
            Supplementaries.LOGGER.info("Synced Common configs");
        });
        context.setPacketHandled(true);
    }
}

