/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.generation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.world.generation.ConfiguredFeaturesRegistry;
import net.mehvahdjukaar.supplementaries.common.world.generation.FeaturesRegistry;
import net.mehvahdjukaar.supplementaries.common.world.generation.StructuresRegistry;
import net.mehvahdjukaar.supplementaries.mixins.accessors.ChunkGeneratorAccessor;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldGenHandler {
    public static void registerBus(IEventBus modEventBus) {
        StructuresRegistry.STRUCTURES.register(modEventBus);
        FeaturesRegistry.FEATURES.register(modEventBus);
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(EventPriority.NORMAL, WorldGenHandler::addDimensionalSpacing);
        bus.addListener(EventPriority.NORMAL, WorldGenHandler::addStuffToBiomes);
    }

    public static void setup(FMLCommonSetupEvent event) {
        StructuresRegistry.setupStructures();
        ConfiguredFeaturesRegistry.registerFeatures();
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ChunkGeneratorAccessor accessor;
            ResourceLocation cgRL;
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof ChunkGeneratorAccessor && (cgRL = Registry.f_122890_.m_7981_((accessor = (ChunkGeneratorAccessor)chunkGenerator).invokeCodec())) != null && cgRL.m_135827_().equals("terraforged")) {
                return;
            }
            if (chunkGenerator instanceof FlatLevelSource || !serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            if ((Integer)ServerConfigs.spawn.ROAD_SIGN_DISTANCE_MIN.get() == 1001) {
                return;
            }
            StructureSettings worldStructureSettings = chunkGenerator.m_62205_();
            HashMap STStructureToMultiMap = new HashMap();
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                Biome.BiomeCategory biomeCategory;
                StructureFeatureConfiguration structurefeatureconfiguration = worldStructureSettings.m_64593_(StructureFeature.f_67028_);
                ImmutableMultimap immutablemultimap = worldStructureSettings.m_189371_(StructureFeature.f_67028_);
                if (structurefeatureconfiguration == null || immutablemultimap.isEmpty() || (biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_()) == Biome.BiomeCategory.OCEAN || biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.RIVER || biomeCategory == Biome.BiomeCategory.UNDERGROUND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE) continue;
                WorldGenHandler.associateBiomeToConfiguredStructure(STStructureToMultiMap, ConfiguredFeaturesRegistry.CONFIGURED_WAY_SIGN_STRUCTURE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureSettings.f_189361_.entrySet().stream().filter(entry -> !STStructureToMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            STStructureToMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureSettings.f_189361_ = tempStructureToMultiMap.build();
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(worldStructureSettings.m_64590_());
            tempMap.putIfAbsent((StructureFeature)StructuresRegistry.WAY_SIGN.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)StructuresRegistry.WAY_SIGN.get()));
            worldStructureSettings.f_64582_ = tempMap;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> STStructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        STStructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = STStructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            Supplementaries.LOGGER.error("    Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\n    This issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.\n    The two conflicting ConfiguredStructures are: {}, {}\n    The biome that is attempting to be shared: {}\n", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }

    public static void addStuffToBiomes(BiomeLoadingEvent event) {
        Biome.BiomeCategory category = event.getCategory();
        if (category != Biome.BiomeCategory.NETHER && category != Biome.BiomeCategory.THEEND && category != Biome.BiomeCategory.NONE) {
            ResourceKey key;
            Set types;
            ResourceLocation res;
            if (((Boolean)ServerConfigs.spawn.URN_PILE_ENABLED.get()).booleanValue() && !((List)ServerConfigs.spawn.URN_BIOME_BLACKLIST.get()).contains(event.getName().toString())) {
                event.getGeneration().m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, ConfiguredFeaturesRegistry.PLACED_CAVE_URNS);
            }
            if (((Boolean)ServerConfigs.spawn.WILD_FLAX_ENABLED.get()).booleanValue() && (res = event.getName()) != null && category != Biome.BiomeCategory.UNDERGROUND && ((types = BiomeDictionary.getTypes((ResourceKey)(key = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)res)))).contains(BiomeDictionary.Type.SANDY) && (types.contains(BiomeDictionary.Type.HOT) || types.contains(BiomeDictionary.Type.DRY)) || types.contains(BiomeDictionary.Type.RIVER))) {
                event.getGeneration().m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, ConfiguredFeaturesRegistry.PLACED_WILD_FLAX_PATCH);
            }
        }
    }

    public static void registerMobSpawns() {
    }
}

