/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.common.base.Stopwatch;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.mehvahdjukaar.selene.resourcepack.AssetGenerators;
import net.mehvahdjukaar.selene.resourcepack.DynamicTexturePack;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.mehvahdjukaar.selene.resourcepack.VanillaResourceManager;
import net.mehvahdjukaar.selene.textures.Palette;
import net.mehvahdjukaar.selene.textures.Respriter;
import net.mehvahdjukaar.selene.textures.SpriteUtils;
import net.mehvahdjukaar.selene.util.WoodSetType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.WallLanternStuff;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientDynamicResourcesHandler
implements PreparableReloadListener {
    private static final Logger LOGGER = Supplementaries.LOGGER;
    public static final DynamicTexturePack DYNAMIC_TEXTURE_PACK = new DynamicTexturePack(Supplementaries.res("virtual_resourcepack"));
    private boolean firstLoad = false;

    public static void registerBus(IEventBus bus) {
        DYNAMIC_TEXTURE_PACK.registerPack(bus);
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)new ClientDynamicResourcesHandler());
        ClientDynamicResourcesHandler.DYNAMIC_TEXTURE_PACK.generateDebugResources = (Boolean)RegistryConfigs.reg.DEBUG_RESOURCES.get();
    }

    private void generateStaticResources(ResourceManager manager) {
        Stopwatch watch = Stopwatch.createStarted();
        AssetGenerators.LangBuilder langBuilder = new AssetGenerators.LangBuilder();
        RPUtils.StaticResource hsBlockState = this.getResOrLog(manager, RPUtils.resPath((ResourceLocation)Supplementaries.res("hanging_sign_oak"), (RPUtils.ResType)RPUtils.ResType.BLOCKSTATES));
        RPUtils.StaticResource hsModel = this.getResOrLog(manager, RPUtils.resPath((ResourceLocation)Supplementaries.res("hanging_signs/hanging_sign_oak"), (RPUtils.ResType)RPUtils.ResType.BLOCK_MODELS));
        RPUtils.StaticResource hsLoader = this.getResOrLog(manager, RPUtils.resPath((ResourceLocation)Supplementaries.res("hanging_signs/loader_template"), (RPUtils.ResType)RPUtils.ResType.BLOCK_MODELS));
        RPUtils.StaticResource hsItemModel = this.getResOrLog(manager, RPUtils.resPath((ResourceLocation)Supplementaries.res("hanging_sign_oak"), (RPUtils.ResType)RPUtils.ResType.ITEM_MODELS));
        for (Map.Entry<WoodSetType, HangingSignBlock> e : ModRegistry.HANGING_SIGNS.entrySet()) {
            WoodSetType wood = e.getKey();
            HangingSignBlock v = e.getValue();
            String id = wood.getVariantId("hanging_sign");
            langBuilder.addEntry((Block)v, wood.getNameForTranslation("hanging_sign"));
            try {
                DYNAMIC_TEXTURE_PACK.addSimilarJsonResource(hsBlockState, "hanging_sign_oak", id);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to generate Hanging Sign blockstate definition for {} : {}", (Object)v, (Object)ex);
            }
            try {
                DYNAMIC_TEXTURE_PACK.addSimilarJsonResource(hsModel, "hanging_sign_oak", id);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to generate Hanging Sign block model for {} : {}", (Object)v, (Object)ex);
            }
            try {
                DYNAMIC_TEXTURE_PACK.addSimilarJsonResource(hsItemModel, "hanging_sign_oak", id);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to generate Hanging Sign item model for {} : {}", (Object)v, (Object)ex);
            }
            try {
                String logTexture;
                try {
                    logTexture = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)Objects.requireNonNull(wood.logBlock), s -> !s.contains("top"));
                }
                catch (Exception e1) {
                    logTexture = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.plankBlock, s -> true);
                    LOGGER.error("Could not properly generate Hanging Sign model for {}. Falling back to planks texture : {}", (Object)v, (Object)e1);
                }
                this.addHangingSignLoaderModel(Objects.requireNonNull(hsLoader), id, logTexture);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to generate Hanging Sign loader model for {} : {}", (Object)v, (Object)ex);
            }
        }
        RPUtils.StaticResource spItemModel = this.getResOrLog(manager, RPUtils.resPath((ResourceLocation)Supplementaries.res("sign_post_oak"), (RPUtils.ResType)RPUtils.ResType.ITEM_MODELS));
        for (Map.Entry<WoodSetType, SignPostItem> e : ModRegistry.SIGN_POST_ITEMS.entrySet()) {
            WoodSetType wood = e.getKey();
            if (wood.isVanilla()) {
                // empty if block
            }
            SignPostItem v = e.getValue();
            langBuilder.addEntry((Item)v, e.getKey().getNameForTranslation("sign_post"));
            try {
                DYNAMIC_TEXTURE_PACK.addSimilarJsonResource(spItemModel, "sign_post_oak", wood.getVariantId("sign_post"));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to generate Sign Post item model for {} : {}", (Object)v, (Object)ex);
            }
        }
        DYNAMIC_TEXTURE_PACK.addLang(Supplementaries.res("en_us"), langBuilder.build());
        LOGGER.info("Generated runtime client resources in: {} seconds", (Object)watch.elapsed().toSeconds());
    }

    public void addHangingSignLoaderModel(RPUtils.StaticResource resource, String woodTextPath, String logTexture) {
        String string = new String(resource.data, StandardCharsets.UTF_8);
        string = string.replace("wood_type", woodTextPath);
        string = string.replace("log_texture", logTexture);
        ResourceLocation newRes = Supplementaries.res("hanging_signs/" + woodTextPath + "_loader");
        DYNAMIC_TEXTURE_PACK.addBytes(newRes, string.getBytes(), RPUtils.ResType.BLOCK_MODELS);
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager manager, ProfilerFiller workerProfiler, ProfilerFiller mainProfiler, Executor workerExecutor, Executor mainExecutor) {
        WallLanternStuff.onResourceReload(manager);
        boolean resourcePackSupport = (Boolean)ClientConfigs.general.RESOURCE_PACK_SUPPORT.get();
        if (!this.firstLoad) {
            this.firstLoad = true;
            this.generateStaticResources(manager);
            if (!resourcePackSupport) {
                VanillaResourceManager vanillaManager = new VanillaResourceManager();
                this.generateDynamicTextures((ResourceManager)vanillaManager);
                vanillaManager.close();
            }
        }
        if (resourcePackSupport) {
            this.generateDynamicTextures(manager);
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> null, workerExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(noResult -> {}, mainExecutor);
    }

    protected void generateDynamicTextures(ResourceManager manager) {
        SignPostItem v;
        ResourceLocation textureRes;
        WoodSetType wood;
        Respriter respriter;
        Palette targetPalette;
        HangingSignBlock v2;
        ResourceLocation textureRes2;
        WoodSetType wood2;
        Respriter respriter2;
        Palette palette;
        NativeImage template;
        try {
            template = this.readImage(manager, Supplementaries.res("textures/blocks/hanging_signs/hanging_sign_oak.png"));
            try (NativeImage mask = this.readImage(manager, Supplementaries.res("textures/blocks/hanging_signs/board_mask.png"));){
                palette = Palette.fromImage((NativeImage)template, (NativeImage)mask);
                respriter2 = new Respriter(template, palette);
                for (Map.Entry<WoodSetType, HangingSignBlock> e : ModRegistry.HANGING_SIGNS.entrySet()) {
                    wood2 = e.getKey();
                    textureRes2 = Supplementaries.res(String.format("blocks/hanging_signs/%s", wood2.getVariantId("hanging_sign")));
                    if (this.hasHandmadeTexture(manager, textureRes2)) continue;
                    v2 = e.getValue();
                    try {
                        NativeImage plankPalette = RPUtils.findFirstBlockTexture((ResourceManager)manager, (Block)wood2.plankBlock);
                        try {
                            targetPalette = SpriteUtils.extrapolateSignBlockPalette((NativeImage)plankPalette);
                            NativeImage newImage = respriter2.recolorImage(targetPalette);
                            DYNAMIC_TEXTURE_PACK.addTexture(textureRes2, newImage);
                        }
                        finally {
                            if (plankPalette == null) continue;
                            plankPalette.close();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to generate Hanging Sign block texture for for {} : {}", (Object)v2, (Object)ex);
                    }
                }
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not generate any Hanging Sign block texture : ", (Throwable)ex);
        }
        try (NativeImage boardTemplate = this.readImage(manager, Supplementaries.res("textures/items/hanging_signs/template.png"));
             NativeImage boardMask = this.readImage(manager, Supplementaries.res("textures/items/hanging_signs/board_mask.png"));){
            palette = Palette.fromImage((NativeImage)boardTemplate, (NativeImage)boardMask);
            respriter2 = new Respriter(boardTemplate, palette);
            for (Map.Entry<WoodSetType, HangingSignBlock> e : ModRegistry.HANGING_SIGNS.entrySet()) {
                wood2 = e.getKey();
                textureRes2 = Supplementaries.res(String.format("items/hanging_signs/%s", wood2.getVariantId("hanging_sign")));
                if (this.hasHandmadeTexture(manager, textureRes2)) continue;
                v2 = e.getValue();
                NativeImage newImage = null;
                if (wood2.signItem != null) {
                    try (NativeImage vanillaSign = RPUtils.findFirstItemTexture((ResourceManager)manager, (Item)((Item)wood2.signItem.get()));
                         NativeImage signMask = this.readImage(manager, Supplementaries.res("textures/items/hanging_signs/sign_board_mask.png"));){
                        Palette targetPalette2 = Palette.fromImage((NativeImage)vanillaSign, (NativeImage)signMask);
                        newImage = respriter2.recolorImage(targetPalette2);
                        try (NativeImage scribbles = this.recolorFromVanilla(manager, vanillaSign, Supplementaries.res("textures/items/hanging_signs/sign_scribbles_mask.png"), Supplementaries.res("textures/items/hanging_signs/scribbles_template.png"));){
                            SpriteUtils.mergeImages((NativeImage)newImage, (NativeImage[])new NativeImage[]{scribbles});
                        }
                        catch (Exception ex) {
                            LOGGER.error("Could not properly color Hanging Sign texture for {} : {}", (Object)v2, (Object)ex);
                        }
                        try (NativeImage stick = this.recolorFromVanilla(manager, vanillaSign, Supplementaries.res("textures/items/hanging_signs/sign_stick_mask.png"), Supplementaries.res("textures/items/hanging_signs/stick_template.png"));){
                            SpriteUtils.mergeImages((NativeImage)newImage, (NativeImage[])new NativeImage[]{stick});
                        }
                        catch (Exception ex) {
                            LOGGER.error("Could not properly color Hanging Sign item texture for {} : {}", (Object)v2, (Object)ex);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Could not find sign texture for wood type {}. Using plank texture : {}", (Object)wood2, (Object)ex);
                    }
                }
                if (newImage == null) {
                    try (NativeImage plankPalette = RPUtils.findFirstBlockTexture((ResourceManager)manager, (Block)wood2.plankBlock);){
                        Palette targetPalette3 = SpriteUtils.extrapolateWoodItemPalette((NativeImage)plankPalette);
                        newImage = respriter2.recolorImage(targetPalette3);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to generate Hanging Sign item texture for for {} : {}", (Object)v2, (Object)ex);
                    }
                }
                if (newImage == null) continue;
                DYNAMIC_TEXTURE_PACK.addTexture(textureRes2, newImage);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not generate any Hanging Sign item texture : ", (Throwable)ex);
        }
        try {
            template = this.readImage(manager, Supplementaries.res("textures/items/sign_posts/template.png"));
            try {
                respriter = new Respriter(template);
                for (Map.Entry<WoodSetType, SignPostItem> e : ModRegistry.SIGN_POST_ITEMS.entrySet()) {
                    wood = e.getKey();
                    textureRes = Supplementaries.res(String.format("items/sign_posts/%s", wood.getVariantId("sign_post")));
                    if (this.hasHandmadeTexture(manager, textureRes)) continue;
                    v = e.getValue();
                    NativeImage newImage = null;
                    if (wood.signItem != null) {
                        try (NativeImage vanillaSign = RPUtils.findFirstItemTexture((ResourceManager)manager, (Item)((Item)wood.signItem.get()));
                             NativeImage signMask = this.readImage(manager, Supplementaries.res("textures/items/hanging_signs/sign_board_mask.png"));){
                            targetPalette = Palette.fromImage((NativeImage)vanillaSign, (NativeImage)signMask);
                            newImage = respriter.recolorImage(targetPalette);
                            try (NativeImage scribbles = this.recolorFromVanilla(manager, vanillaSign, Supplementaries.res("textures/items/hanging_signs/sign_scribbles_mask.png"), Supplementaries.res("textures/items/sign_posts/scribbles_template.png"));){
                                SpriteUtils.mergeImages((NativeImage)newImage, (NativeImage[])new NativeImage[]{scribbles});
                            }
                            catch (Exception ex) {
                                LOGGER.error("Could not properly color Sign Post item texture for {} : {}", (Object)v, (Object)ex);
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.error("Could not find sign texture for wood type {}. Using plank texture : {}", (Object)wood, (Object)ex);
                        }
                    }
                    if (newImage == null) {
                        try (NativeImage plankPalette = RPUtils.findFirstBlockTexture((ResourceManager)manager, (Block)wood.plankBlock);){
                            Palette targetPalette4 = SpriteUtils.extrapolateWoodItemPalette((NativeImage)plankPalette);
                            newImage = respriter.recolorImage(targetPalette4);
                        }
                        catch (Exception ex) {
                            LOGGER.error("Failed to generate Sign Post item texture for for {} : {}", (Object)v, (Object)ex);
                        }
                    }
                    if (newImage == null) continue;
                    DYNAMIC_TEXTURE_PACK.addTexture(textureRes, newImage);
                }
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = this.readImage(manager, Supplementaries.res("textures/entity/sign_posts/sign_post_oak.png"));
            try {
                respriter = new Respriter(template);
                for (Map.Entry<WoodSetType, SignPostItem> e : ModRegistry.SIGN_POST_ITEMS.entrySet()) {
                    wood = e.getKey();
                    textureRes = Supplementaries.res(String.format("entity/sign_posts/%s", wood.getVariantId("sign_post")));
                    if (this.hasHandmadeTexture(manager, textureRes)) continue;
                    v = e.getValue();
                    try {
                        NativeImage plankPalette = RPUtils.findFirstBlockTexture((ResourceManager)manager, (Block)wood.plankBlock);
                        try {
                            NativeImage newImage = respriter.recolorImage(plankPalette, null);
                            DYNAMIC_TEXTURE_PACK.addTexture(textureRes, newImage);
                        }
                        finally {
                            if (plankPalette == null) continue;
                            plankPalette.close();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to generate Sign Post block texture for for {} : {}", (Object)v, (Object)ex);
                    }
                }
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not generate any Sign Post block texture : ", (Throwable)ex);
        }
    }

    private boolean hasHandmadeTexture(ResourceManager manager, ResourceLocation res) {
        ResourceLocation fullRes = RPUtils.resPath((ResourceLocation)res, (RPUtils.ResType)RPUtils.ResType.TEXTURES);
        if (manager.m_7165_(fullRes)) {
            try {
                Resource r = manager.m_142591_(fullRes);
                return !r.m_7816_().equals(DYNAMIC_TEXTURE_PACK.m_8017_());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    private NativeImage recolorFromVanilla(ResourceManager manager, NativeImage vanillaTexture, ResourceLocation vanillaMask, ResourceLocation templateTexture) {
        try {
            NativeImage scribbleMask = this.readImage(manager, vanillaMask);
            NativeImage scribbleTemplate = this.readImage(manager, templateTexture);
            Respriter scribbleRespriter = new Respriter(scribbleTemplate);
            return scribbleRespriter.recolorImage(vanillaTexture, scribbleMask);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private NativeImage readImage(ResourceManager manager, ResourceLocation resourceLocation) throws IOException {
        return NativeImage.m_85058_((InputStream)manager.m_142591_(resourceLocation).m_6679_());
    }

    @Nullable
    private RPUtils.StaticResource getResOrLog(ResourceManager manager, ResourceLocation location) {
        try {
            return new RPUtils.StaticResource(manager.m_142591_(location));
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error("Could not find resource {} while generating dynamic resource pack", (Object)location);
            return null;
        }
    }
}

