/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.mehvahdjukaar.selene.resourcepack.DynamicDataPack;
import net.mehvahdjukaar.selene.util.WoodSetType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.common.items.crafting.OptionalRecipeCondition;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerDynamicResourcesHandler {
    public static final DynamicDataPack DYNAMIC_DATA_PACK = new DynamicDataPack(Supplementaries.res("virtual_resourcepack"));

    public static void registerBus(IEventBus forgeBus) {
        DYNAMIC_DATA_PACK.registerPack((IEventBus)((EventBus)forgeBus));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ServerDynamicResourcesHandler::generateAssets);
    }

    public static void generateAssets(FMLCommonSetupEvent event) {
        Stopwatch watch = Stopwatch.createStarted();
        ArrayList<ResourceLocation> signs = new ArrayList<ResourceLocation>();
        for (HangingSignBlock hangingSignBlock : ModRegistry.HANGING_SIGNS.values()) {
            DYNAMIC_DATA_PACK.addSimpleBlockLootTable((Block)hangingSignBlock);
            signs.add(hangingSignBlock.getRegistryName());
            ServerDynamicResourcesHandler.makeHangingSignRecipe(hangingSignBlock.woodType, arg_0 -> ((DynamicDataPack)DYNAMIC_DATA_PACK).addRecipe(arg_0));
        }
        DYNAMIC_DATA_PACK.addTag(Supplementaries.res("hanging_signs"), signs, new DynamicDataPack.TagType[]{DynamicDataPack.TagType.BLOCKS, DynamicDataPack.TagType.ITEMS});
        ArrayList<ResourceLocation> posts = new ArrayList<ResourceLocation>();
        for (SignPostItem signPostItem : ModRegistry.SIGN_POST_ITEMS.values()) {
            posts.add(signPostItem.getRegistryName());
            ServerDynamicResourcesHandler.makeSignPostRecipe(signPostItem.woodType, arg_0 -> ((DynamicDataPack)DYNAMIC_DATA_PACK).addRecipe(arg_0));
        }
        DYNAMIC_DATA_PACK.addTag(Supplementaries.res("sign_posts"), posts, new DynamicDataPack.TagType[]{DynamicDataPack.TagType.ITEMS});
        Supplementaries.LOGGER.info("Generated runtime data resources in: {} seconds", (Object)watch.elapsed().toSeconds());
    }

    public static void makeConditionalRec(FinishedRecipe r, Consumer<FinishedRecipe> consumer, String name) {
        ConditionalRecipe.builder().addCondition((ICondition)new OptionalRecipeCondition(name)).addRecipe(r).build(consumer, "supplementaries", name);
    }

    public static void makeConditionalWoodRec(FinishedRecipe r, WoodSetType wood, Consumer<FinishedRecipe> consumer, String name) {
        ConditionalRecipe.builder().addCondition((ICondition)new OptionalRecipeCondition(name)).addCondition((ICondition)new ModLoadedCondition(wood.getNamespace())).addRecipe(r).generateAdvancement().build(consumer, "supplementaries", name + "_" + wood.getAppendableId());
    }

    private static ResourceLocation getPlankRegName(WoodSetType wood) {
        return new ResourceLocation(wood.getNamespace(), wood.getWoodName() + "_planks");
    }

    private static ResourceLocation getSignRegName(WoodSetType wood) {
        return new ResourceLocation(wood.getNamespace(), wood.getWoodName() + "_sign");
    }

    private static void makeSignPostRecipe(WoodSetType wood, Consumer<FinishedRecipe> consumer) {
        try {
            Item plank = wood.plankBlock.m_5456_();
            Preconditions.checkArgument((plank != Items.f_41852_ ? 1 : 0) != 0);
            Item sign = (Item)ForgeRegistries.ITEMS.getValue(ServerDynamicResourcesHandler.getSignRegName(wood));
            if (sign != null && sign != Items.f_41852_) {
                ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(wood)), (int)2).m_126209_((ItemLike)sign).m_142409_("sign_post").m_142284_("has_plank", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{plank})).m_176498_(s -> ServerDynamicResourcesHandler.makeConditionalWoodRec(s, wood, consumer, "sign_post"));
            } else {
                ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(wood)), (int)3).m_126130_("   ").m_126130_("222").m_126130_(" 1 ").m_126127_(Character.valueOf('1'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('2'), (ItemLike)plank).m_142409_("sign_post").m_142284_("has_plank", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{plank})).m_176498_(s -> ServerDynamicResourcesHandler.makeConditionalWoodRec(s, wood, consumer, "sign_post"));
            }
        }
        catch (Exception ignored) {
            Supplementaries.LOGGER.error("Failed to generate sign post recipe for wood type {}", (Object)wood);
        }
    }

    private static void makeHangingSignRecipe(WoodSetType wood, Consumer<FinishedRecipe> consumer) {
        try {
            Item plank = wood.plankBlock.m_5456_();
            Preconditions.checkArgument((plank != Items.f_41852_ ? 1 : 0) != 0);
            ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ModRegistry.HANGING_SIGNS.get(wood)), (int)2).m_126130_("010").m_126130_("222").m_126130_("222").m_126127_(Character.valueOf('0'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('1'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('2'), (ItemLike)plank).m_142409_("hanging_sign").m_142284_("has_plank", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{plank})).m_176498_(s -> ServerDynamicResourcesHandler.makeConditionalWoodRec(s, wood, consumer, "hanging_sign"));
        }
        catch (Exception ignored) {
            Supplementaries.LOGGER.error("Failed to generate hanging sign recipe for wood type {}", (Object)wood);
        }
    }
}

