/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import java.util.ArrayList;
import java.util.Collections;
import net.mehvahdjukaar.selene.fluids.FluidTextures;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.utils.Textures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class ModSoftFluids {
    public static final SoftFluid DIRT;
    public static final SoftFluid SAP;
    public static final SoftFluid POWDERED_SNOW;
    public static final SoftFluid UNHOLY_SAP;
    public static final SoftFluid HOLY_SAP;

    public static SoftFluid makeSF(SoftFluid.Builder builder) {
        return new SoftFluid(builder);
    }

    public static void init() {
        SoftFluidRegistry.register((SoftFluid)SAP);
        SoftFluidRegistry.register((SoftFluid)DIRT);
        SoftFluidRegistry.register((SoftFluid)POWDERED_SNOW);
        SoftFluidRegistry.register((SoftFluid)UNHOLY_SAP);
        SoftFluidRegistry.register((SoftFluid)HOLY_SAP);
        ArrayList<SoftFluid> custom = new ArrayList<SoftFluid>(Collections.emptyList());
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "eggnog").fromMod("snowyspirit").color(184544989).translationKey("item.snowyspirit.eggnog").drink("snowyspirit:eggnog")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "komodo_spit").fromMod("alexsmobs").color(11057510).translationKey("item.alexmobs.komodo_spit").bottle("alexsmobs:komodo_spit_bottle")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "squash_soup").fromMod("simplefarming").color(15110922).stew("simplefarming:squash_soup")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder("inspirations:potato_soup").textures(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW).fromMod("inspirations").stew("inspirations:potato_soup")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "fish_oil").fromMod("alexsmobs").color(16771228).translationKey("item.alexsmobs.fish_oil").drink("alexsmobs:fish_oil")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "poison").fromMod("alexsmobs").color(9104231).translationKey("item.alexsmobs.poison_bottle").bottle("alexsmobs:poison_bottle")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "sopa_de_macaco").fromMod("alexsmobs").color(11977092).stew("alexsmobs:sopa_de_macaco")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "baked_cod_stew").fromMod("farmersdelight").color(15519126).stew("farmersdelight:baked_cod_stew")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "beef_stew").fromMod("farmersdelight").color(7421741).stew("farmersdelight:beef_stew")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "chicken_soup").fromMod("farmersdelight").color(14591846).stew("farmersdelight:chicken_soup")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "fish_stew").fromMod("farmersdelight").color(11748384).stew("farmersdelight:fish_stew")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.MILK_TEXTURE, Textures.MILK_TEXTURE, "hot_cocoa").fromMod("farmersdelight").color(9393723).translationKey("item.farmersdelight.hot_cocoa").drink("farmersdelight:hot_cocoa")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "pumpkin_soup").fromMod("farmersdelight").color(14912029).translationKey("item.farmersdelight.pumpkin_soup").stew("farmersdelight:pumpkin_soup")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "tomato_sauce").fromMod("farmersdelight").color(12596255).translationKey("item.farmersdelight.tomato_sauce").stew("farmersdelight:tomato_sauce")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.HONEY_TEXTURE, Textures.POTION_TEXTURE_FLOW, "syrup").fromMod("autumnity").copyTexturesFrom("create:honey").color(9322278).addEqFluid("thermal:syrup").translationKey("item.autumnity.syrup").drink("autumnity:syrup_bottle")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "fire_stew").fromMod("iceandfire").color(15424784).stew("iceandfire:fire_stew")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "frost_stew").fromMod("iceandfire").color(8516345).stew("iceandfire:frost_stew")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "lightning_stew").fromMod("iceandfire").color(7688898).stew("iceandfire:lightning_stew")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "fire_dragon_blood").fromMod("iceandfire").color(15424784).translationKey("item.iceandfire.fire_dragon_blood").drink("iceandfire:fire_dragon_blood")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "lightning_dragon_blood").fromMod("iceandfire").color(10944764).translationKey("item.iceandfire.lightning_dragon_blood").drink("iceandfire:lightning_dragon_blood")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "ice_dragon_blood").fromMod("iceandfire").color(1822716).translationKey("item.iceandfire.ice_dragon_blood").drink("iceandfire:ice_dragon_blood")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "vegetable_soup").fromMod("farmersdelight").color(9074725).stew("farmersdelight:vegetable_soup")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.MILK_TEXTURE, Textures.MILK_TEXTURE, "goat_milk").fromMod("betteranimalsplus").translationKey("item.betteranimalsplus.goatmilk").bucket("betteranimalsplus:goatmilk")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "whiskey").fromMod("simplefarming").color(13799522).translationKey("item.simplefarming.whiskey").drink("simplefarming:whiskey")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "olive_oil").fromMod("simplefarming").color(9871132).translationKey("item.simplefarming.olive_oil").drink("simplefarming:olive_oil")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "vinegar").fromMod("simplefarming").color(13947588).translationKey("item.simplefarming.vinegar").drink("simplefarming:vinegar")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "mead").fromMod("simplefarming").color(12818192).translationKey("item.simplefarming.mead").drink("simplefarming:mead")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "beer").fromMod("simplefarming").color(13342791).translationKey("item.simplefarming.beer").drink("simplefarming:beer")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "cauim").fromMod("simplefarming").color(13615731).translationKey("item.simplefarming.cauim").drink("simplefarming:cauim")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "cider").fromMod("simplefarming").color(14455326).translationKey("item.simplefarming.cider").drink("simplefarming:cider")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "sake").fromMod("simplefarming").color(14931308).translationKey("item.simplefarming.sake").drink("simplefarming:sake")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "tiswin").fromMod("simplefarming").color(14440486).translationKey("item.simplefarming.tiswin").drink("simplefarming:tiswin")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "vodka").fromMod("simplefarming").color(13623275).translationKey("item.simplefarming.vodka").drink("simplefarming:vodka")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "wine").fromMod("simplefarming").color(9837897).translationKey("item.simplefarming.wine").drink("simplefarming:wine")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.HONEY_TEXTURE, Textures.HONEY_TEXTURE, "jam").fromMod("simplefarming").color(9899039).translationKey("item.simplefarming.jam").drink("simplefarming:jam")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "umbrella_cluster_juice").fromMod("betterendforge").color(12473334).translationKey("item.betterendforge.umbrella_cluster_juice").drink("betterendforge:umbrella_cluster_juice")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "soap").fromMod("fluffy_farmer").color(14393087).translationKey("item.fluffy_farmer.soap").bottle("fluffy_farmer:bottle_with_soap_bubbles")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "soap").fromMod("betteranimalsplus").color(6334688).translationKey("item.betteranimalsplus.horseshoe_crab_blood").drink("betteranimalsplus:horseshoe_crab_blood")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder("block/slime/storage/congealed_sky", "block/slime/storage/congealed_sky", "sky_slime").fromMod("tconstruct").emptyHandContainerItem("tconstruct:sky_slime_ball", 1).setSoundsForCategory(SoundEvents.f_12392_, SoundEvents.f_12389_, Items.f_41852_).translationKey("item.tconstruct:sky_slime_ball")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder("tconstruct:block/ichor_congealed_slime", "tconstruct:block/ichor_congealed_slime", "ichor_slime").fromMod("tconstruct").emptyHandContainerItem("tconstruct:ichor_slime_ball", 1).setSoundsForCategory(SoundEvents.f_12392_, SoundEvents.f_12389_, Items.f_41852_).food("tconstruct:ichor_slime_ball")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder("tconstruct:block/blood_congealed_slime", "tconstruct:block/blood_congealed_slime", "blood_slime").fromMod("tconstruct").emptyHandContainerItem("tconstruct:blood_slime_ball", 1).setSoundsForCategory(SoundEvents.f_12392_, SoundEvents.f_12389_, Items.f_41852_).food("tconstruct:blood_slime_ball")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder("tconstruct:block/ender_congealed_slime", "tconstruct:block/ender_congealed_slime", "ender_slime").fromMod("tconstruct").emptyHandContainerItem("tconstruct:ender_slime_ball", 1).setSoundsForCategory(SoundEvents.f_12392_, SoundEvents.f_12389_, Items.f_41852_).food("tconstruct:ender_slime_ball")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder("atmospheric:block/aloe_gel_block_top", Textures.POTION_TEXTURE_FLOW.toString(), "aloe_gel").fromMod("atmospheric").onlyFlowingTinted().translationKey("item.atmospheric:aloe_gel_bottle").emptyHandContainerItem("item.atmospheric:aloe_gel_block", 4).drink("atmospheric:aloe_gel_bottle")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "yucca_juice").fromMod("atmospheric").color(5169467).translationKey("item.atmospheric:yucca_juice").drink("atmospheric:yucca_juice")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder("upgrade_aquatic:block/mulberry_jam_block_top", Textures.POTION_TEXTURE_FLOW.toString(), "mulberry_jam").fromMod("upgrade_aquatic").onlyFlowingTinted().translationKey("item.upgrade_aquatic:mulberry_jam_bottle").emptyHandContainerItem("item.upgrade_aquatic:mulberry_jam_block", 4).drink("upgrade_aquatic:mulberry_jam_bottle")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.DRAGON_BREATH_TEXTURE, Textures.POTION_TEXTURE_FLOW, "ambrosia").fromMod("iceandfire").color(16294107).translationKey("item.iceandfire.ambrosia").stew("iceandfire:ambrosia")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder("create:tea").drink("create:builders_tea")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "lavender_tea").fromMod("abundance").color(533618).translationKey("item.abundance.lavender_tea").drink("abundance:lavender_tea")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "scrambled_eggs").fromMod("environmental").color(14523683).translationKey("item.environmental.scrambled_eggs").stew("environmental:scrambled_eggs")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.MILK_TEXTURE, Textures.MILK_TEXTURE, "siren_tear").fromMod("iceandfire").color(10805500).translationKey("item.iceandfire.siren_tear").emptyHandContainerItem("iceandfire:siren_tear", 1)));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.DRAGON_BREATH_TEXTURE, Textures.POTION_TEXTURE_FLOW, "mimicream").fromMod("alexsmobs").color(8417707).translationKey("item.alexsmobs.mimicream").emptyHandContainerItem("alexsmobs:mimicream", 1).setSoundsForCategory(SoundEvents.f_12392_, SoundEvents.f_12389_, Items.f_41852_)));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "adzuki_milkshake").fromMod("neapolitan").color(15041167).translationKey("item.neapolitan.adzuki_milkshake").bottle("adzuki_milkshake")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "mint_milkshake").fromMod("neapolitan").color(10678192).translationKey("item.neapolitan.mint_milkshake").bottle("mint_milkshake")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "chocolate_milkshake").fromMod("neapolitan").color(7751473).translationKey("item.neapolitan.chocolate_milkshake").bottle("chocolate_milkshake")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "strawberry_milkshake").fromMod("neapolitan").color(15502762).translationKey("item.neapolitan.strawberry_milkshake").bottle("strawberry_milkshake")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "vanilla_milkshake").fromMod("neapolitan").color(16175050).translationKey("item.neapolitan.vanilla_milkshake").bottle("vanilla_milkshake")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "banana_milkshake").fromMod("neapolitan").color(16372368).translationKey("item.neapolitan.banana_milkshake").bottle("banana_milkshake")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "strawberry_banana_smoothie").fromMod("neapolitan").color(14509743).translationKey("item.neapolitan.strawberry_banana_smoothie").bottle("strawberry_banana_smoothie")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "gooseberry_jam").fromMod("bayou_blues").color(15974208).translationKey("item.bayou_blues.gooseberry_jam_bottle").drink("gooseberry_jam:gooseberry_jam_bottle")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "gooseberry_juice").fromMod("bayou_blues").color(12312418).translationKey("item.bayou_blues.gooseberry_juice_bottle").drink("gooseberry_jam:gooseberry_juice_bottle")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.HONEY_TEXTURE, Textures.HONEY_TEXTURE, "holy_syrup").fromMod("malum").color(13408849).translationKey("item.malum.holy_syrup").bottle("malum:holy_syrup")));
        custom.add(ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.HONEY_TEXTURE, Textures.HONEY_TEXTURE, "unholy_syrup").fromMod("malum").color(9446484).translationKey("item.malum.holy_syrup").bottle("malum:unholy_syrup")));
        for (DyeColor c : DyeColor.values()) {
            Item dye = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:" + c.m_41065_() + "_dye"));
            String name = "inspirations:" + c.m_7912_() + "_dye";
            SoftFluid s = ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, name).bottle(name + "d_bottle").translationKey(dye.m_5524_()).color(ColorHelper.pack(c.m_41068_())).fromMod("inspirations").copyTexturesFrom("inspirations:potato_soup"));
            custom.add(s);
        }
        custom.forEach(SoftFluidRegistry::register);
    }

    static {
        POWDERED_SNOW = ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POWDER_SNOW_TEXTURE, Textures.POWDER_SNOW_TEXTURE, "powder_snow").fromMod("supplementaries").bucket(Items.f_151055_).setBucketSounds(SoundEvents.f_144089_, SoundEvents.f_144076_).translationKey("block.minecraft.powder_snow"));
        DIRT = ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.DIRT_TEXTURE, Textures.DIRT_TEXTURE, "dirt").fromMod("supplementaries").emptyHandContainerItem(Items.f_42329_, 4).setSoundsForCategory(SoundEvents.f_11996_, SoundEvents.f_11993_, Items.f_41852_).translationKey("block.minecraft.dirt"));
        SAP = ModSoftFluids.makeSF(new SoftFluid.Builder(FluidTextures.HONEY_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "sap").fromMod("supplementaries").copyTexturesFrom("thermal:sap").color(12414506).drink("autumnity:sap_bottle").bucket("thermal:sap_bucket").translationKey("fluid.supplementaries.sap"));
        HOLY_SAP = ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "holy_sap").fromMod("malum").color(14389063).translationKey("item.malum:holy_sap").bottle("malum:holy_sap"));
        UNHOLY_SAP = ModSoftFluids.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "unholy_sap").fromMod("malum").color(7742800).translationKey("item.malum:unholy_sap").bottle("malum:unholy_sap"));
    }
}

