/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.registry.ModTriggers;

public final class CompatibilityMinecolonies {
    public static final CompatibilityMinecolonies instance = new CompatibilityMinecolonies();
    private static final Set<String> RAIDERS = ImmutableSet.of((Object)"barbarian", (Object)"archerbarbarian", (Object)"pirate", (Object)"archerpirate", (Object)"amazon", (Object)"shieldmaiden", (Object[])new String[]{"norsemenarcher", "archermummy", "pharao", "mummy", "chiefbarbarian", "chiefpirate", "amazonchief", "norsemenchief"});

    private CompatibilityMinecolonies() {
    }

    public boolean isCitizen(@Nullable Entity entity) {
        return CreatureType.getType(entity) == CreatureType.CITIZEN;
    }

    public Optional<GlobalPos> getHomePos(LivingEntity entity) {
        if (SupportMods.MINECOLONIES.isLoaded()) {
            try {
                IColony colony = ((AbstractEntityCitizen)entity).getCitizenColonyHandler().getColony();
                if (colony != null) {
                    return Optional.of(GlobalPos.m_122643_((ResourceKey)colony.getDimension(), (BlockPos)colony.getCenter()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public boolean applyKillResult(ServerPlayer player, EntityType<?> entityType) {
        CreatureType type = CreatureType.getType(entityType);
        if (type == CreatureType.CITIZEN) {
            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 0, (Integer)ConfigTombstone.alignment.pointsKillVillager.get()));
            ModTriggers.KILL_ENOUGH_VILLAGER.trigger(player);
            return true;
        }
        if (type == CreatureType.RAIDER) {
            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 0, (Integer)ConfigTombstone.alignment.pointsKillRaider.get()));
            ModTriggers.KILL_ENOUGH_RAIDER.trigger(player);
            return true;
        }
        return false;
    }

    public static enum CreatureType {
        CITIZEN,
        RAIDER,
        UNKNOWN;


        public static CreatureType getType(@Nullable Entity entity) {
            return Optional.ofNullable(entity).map(Entity::m_6095_).map(CreatureType::getType).orElse(UNKNOWN);
        }

        public static CreatureType getType(EntityType<?> type) {
            ResourceLocation rl;
            if (SupportMods.MINECOLONIES.isLoaded() && (rl = type.getRegistryName()) != null) {
                if ("citizen".equals(rl.m_135815_())) {
                    return CITIZEN;
                }
                if (RAIDERS.contains(rl.m_135815_())) {
                    return RAIDER;
                }
            }
            return UNKNOWN;
        }
    }
}

