/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import ovh.corail.tombstone.registry.ModDamages;

public enum DamageType implements StringRepresentable
{
    SUFFOCATION,
    BURN,
    LIGHTNING,
    FALL,
    COLD,
    DARKNESS,
    LIGHT,
    UNKNOWN;

    private static final Map<String, DamageType> DAMAGE_STRINGS;
    private final String name = this.name().toLowerCase(Locale.US);

    public boolean is(DamageSource s) {
        return DamageType.of(s) == this;
    }

    public static DamageType of(DamageSource s) {
        if (s.m_19384_()) {
            return BURN;
        }
        if (s == DamageSource.f_19306_) {
            return LIGHTNING;
        }
        if (s == DamageSource.f_146701_) {
            return COLD;
        }
        if (s == DamageSource.f_19312_ || s == DamageSource.f_19310_ || s == DamageSource.f_19311_ || s == DamageSource.f_19313_) {
            return SUFFOCATION;
        }
        if (s.m_146707_() || s == DamageSource.f_19316_) {
            return FALL;
        }
        if (s == DamageSource.f_19320_ || s == ModDamages.BEYOND_THE_GRAVE || s == DamageSource.f_19323_) {
            return DARKNESS;
        }
        String type = s.m_19385_().toLowerCase(Locale.US);
        return DAMAGE_STRINGS.computeIfAbsent(type, DamageType::fromString);
    }

    private static DamageType fromString(String type) {
        if (DamageType.contains(type, "lightning", "electr", "discharg")) {
            return LIGHTNING;
        }
        if (DamageType.contains(type, "spore", "poison")) {
            return SUFFOCATION;
        }
        if (DamageType.contains(type, "lich", "haunt", "darkness")) {
            return DARKNESS;
        }
        if (type.startsWith("ice") || DamageType.contains(type, "chill", "frost", "froz", "freez", "snow", "cold")) {
            return COLD;
        }
        return UNKNOWN;
    }

    private static boolean contains(String type, String ... containWords) {
        return Arrays.stream(containWords).anyMatch(type::contains);
    }

    public String m_7912_() {
        return this.name;
    }

    static {
        DAMAGE_STRINGS = new HashMap<String, DamageType>();
    }
}

