/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import ovh.corail.tombstone.api.item.IImpregnable;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;

public interface IDefaultImpregnable
extends IImpregnable {
    public static final String ENTITY_TYPE_NBT_STRING = "entity_type";

    @Override
    default public String getEntityType(ItemStack stack) {
        return stack.m_41720_() == this ? NBTStackHelper.getString(stack, ENTITY_TYPE_NBT_STRING) : "";
    }

    @Override
    default public ItemStack impregnate(ItemStack stack, String entityType) {
        if (stack.m_41720_() == this) {
            NBTStackHelper.setString(stack, ENTITY_TYPE_NBT_STRING, entityType);
        }
        return stack;
    }

    @Override
    default public boolean impregnate(ItemStack stack, @Nullable LivingEntity entity) {
        ResourceLocation registryName;
        if (entity != null && stack.m_41720_() == this && this.getEntityType(stack).isEmpty() && (registryName = entity.m_6095_().getRegistryName()) != null) {
            NBTStackHelper.setString(stack, ENTITY_TYPE_NBT_STRING, registryName.toString());
            return true;
        }
        return false;
    }

    @Override
    default public boolean isImpregnated(ItemStack stack) {
        return stack.m_41720_() == this && stack.m_41783_() != null && stack.m_41783_().m_128425_(ENTITY_TYPE_NBT_STRING, 8);
    }

    @Override
    @Nullable
    default public Component getTooltipDisplay(ItemStack stack) {
        String id = this.getEntityType(stack);
        return id.isEmpty() ? null : LangKey.MESSAGE_IMPREGNATE.getText(StyleType.TOOLTIP_ENCHANT, new Object[]{LangKey.getEntityName(id)});
    }
}

