/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;

public record EffectMessage(int entityId, MobEffectInstance effectInstance) {
    static EffectMessage fromBytes(FriendlyByteBuf buf) {
        return new EffectMessage(buf.readInt(), Optional.ofNullable(buf.m_130260_()).map(MobEffectInstance::m_19560_).orElse(new MobEffectInstance(MobEffects.f_19618_)));
    }

    static void toBytes(EffectMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.m_130079_(msg.effectInstance.m_19555_(new CompoundTag()));
    }

    public static class Handler {
        static void handle(EffectMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> ModTombstone.PROXY.getClientWorld().map(level -> level.m_6815_(msg.entityId)).filter(LivingEntity.class::isInstance).ifPresent(entity -> EffectHelper.addEffect((LivingEntity)entity, msg.effectInstance)));
            }
            ctx.setPacketHandled(true);
        }
    }
}

