/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.registry.ModTriggers;

public record UpdateServerMessage(PlayerPreference playerPreference, boolean isLogin) {
    static UpdateServerMessage fromBytes(FriendlyByteBuf buf) {
        return new UpdateServerMessage(PlayerPreference.fromBytes(buf), buf.readBoolean());
    }

    static void toBytes(UpdateServerMessage msg, FriendlyByteBuf buf) {
        PlayerPreference.toBytes(msg.playerPreference, buf);
        buf.writeBoolean(msg.isLogin);
    }

    public static class Handler {
        static void handle(UpdateServerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    ServerPlayer player = ctx.getSender();
                    if (player != null) {
                        PlayerPreference oldPlayerPreference = PlayerPreference.get(player.m_142081_());
                        PlayerPreference.set(player, message.playerPreference);
                        if (!message.isLogin && !message.playerPreference.hasSameFavoriteGrave(oldPlayerPreference)) {
                            ModTriggers.CHOOSE_GRAVE_TYPE.trigger(player);
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

