/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.Shape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.utils.PlatformMethods;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class FTBUltiminePlayerData {
    public final UUID id;
    public boolean pressed = false;
    public Shape shape = Shape.get("");
    public BlockPos cachedPos;
    public Direction cachedDirection;
    public List<BlockPos> cachedBlocks;

    public FTBUltiminePlayerData(UUID i) {
        this.id = i;
    }

    public void clearCache() {
        this.cachedPos = null;
        this.cachedDirection = null;
        this.cachedBlocks = null;
    }

    public static HitResult rayTrace(ServerPlayer player) {
        double distance = PlatformMethods.reach(player);
        return player.m_19907_(player.m_7500_() ? distance : distance - 0.5, 1.0f, false);
    }

    public void checkBlocks(ServerPlayer player, boolean sendUpdate, int maxBlocks) {
        if (!this.pressed) {
            return;
        }
        HitResult result = FTBUltiminePlayerData.rayTrace(player);
        if (!(result instanceof BlockHitResult) || result.m_6662_() != HitResult.Type.BLOCK) {
            if (this.cachedBlocks != null && !this.cachedBlocks.isEmpty()) {
                this.clearCache();
                if (sendUpdate) {
                    new SendShapePacket(this.shape, Collections.emptyList()).sendTo(player);
                }
            }
            return;
        }
        BlockHitResult r = (BlockHitResult)result;
        if (this.cachedDirection != r.m_82434_() || this.cachedPos == null || !this.cachedPos.equals((Object)r.m_82425_())) {
            this.updateBlocks(player, r.m_82425_(), r.m_82434_(), sendUpdate, maxBlocks);
        }
    }

    @Nullable
    public ShapeContext updateBlocks(ServerPlayer player, BlockPos p, Direction d, boolean sendUpdate, int maxBlocks) {
        ShapeContext context = null;
        this.cachedPos = p;
        this.cachedDirection = d;
        if (maxBlocks <= 0) {
            this.cachedBlocks = Collections.emptyList();
        } else {
            context = new ShapeContext();
            context.player = player;
            context.pos = this.cachedPos;
            context.face = this.cachedDirection;
            context.matcher = BlockMatcher.MATCH;
            context.maxBlocks = maxBlocks;
            context.original = player.f_19853_.m_8055_(this.cachedPos);
            if (BlockMatcher.TAGS_MATCH.actualCheck(context.original, context.original)) {
                context.matcher = BlockMatcher.TAGS_MATCH;
            } else if (BlockMatcher.BUSH.actualCheck(context.original, context.original)) {
                context.matcher = BlockMatcher.BUSH;
            }
            this.cachedBlocks = this.shape.getBlocks(context);
        }
        if (sendUpdate) {
            new SendShapePacket(this.shape, this.cachedBlocks).sendTo(player);
        }
        return context;
    }
}

