/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;

public interface ICreativeTabBuilder<BT extends ICreativeTabBuilder<BT>> {
    default public BT setIcon(ItemLike icon) {
        return this.setIcon(new ItemStack(icon));
    }

    default public BT setIcon(ItemStack icon) {
        return this.setIcon(() -> icon);
    }

    default public BT setIconItem(Supplier<ItemLike> iconSupplier) {
        return this.setIcon(() -> new ItemStack((ItemLike)iconSupplier.get()));
    }

    public BT setIcon(Supplier<ItemStack> var1);

    public BT setEnchantmentCategories(EnchantmentCategory ... var1);

    default public BT setTabContents(List<ItemStack> items) {
        return this.setTabContents((List<ItemStack> tabContents) -> tabContents.addAll(items));
    }

    public BT setTabContents(Consumer<List<ItemStack>> var1);

    public CreativeModeTab build();

    public ResourceLocation getTabId();
}

