/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.registry;

import net.darkhax.bookshelf.api.item.ICreativeTabBuilder;
import net.darkhax.bookshelf.api.registry.ICommandBuilder;
import net.darkhax.bookshelf.api.registry.IRegistryEntries;
import net.darkhax.bookshelf.api.registry.VillagerTradeEntries;
import net.darkhax.bookshelf.impl.registry.RegistryEntries;
import net.darkhax.bookshelf.mixin.item.AccessorItem;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;

public abstract class RegistryHelper {
    public final String ownerId;
    public final IRegistryEntries<Block> blocks;
    public final IRegistryEntries<Item> items;
    public final IRegistryEntries<Enchantment> enchantments;
    public final IRegistryEntries<Motive> paintings;
    public final IRegistryEntries<MobEffect> mobEffects;
    public final IRegistryEntries<Attribute> attributes;
    public final IRegistryEntries<VillagerProfession> villagerProfessions;
    public final IRegistryEntries<PreparableReloadListener> serverReloadListeners;
    public final IRegistryEntries<PreparableReloadListener> clientReloadListeners;
    public final IRegistryEntries<ICommandBuilder> commands;
    public final IRegistryEntries<Tuple<Class, ArgumentSerializer>> commandArguments;
    public final VillagerTradeEntries trades;

    protected RegistryHelper(String ownerId) {
        this.ownerId = ownerId;
        this.blocks = new RegistryEntries<Block>(ownerId);
        this.items = new RegistryEntries<Item>(ownerId);
        this.enchantments = new RegistryEntries<Enchantment>(ownerId);
        this.paintings = new RegistryEntries<Motive>(ownerId);
        this.mobEffects = new RegistryEntries<MobEffect>(ownerId);
        this.attributes = new RegistryEntries<Attribute>(ownerId);
        this.villagerProfessions = new RegistryEntries<VillagerProfession>(ownerId);
        this.serverReloadListeners = new RegistryEntries<PreparableReloadListener>(ownerId);
        this.clientReloadListeners = new RegistryEntries<PreparableReloadListener>(ownerId);
        this.commands = new RegistryEntries<ICommandBuilder>(ownerId);
        this.commandArguments = new RegistryEntries<Tuple<Class, ArgumentSerializer>>(ownerId);
        this.trades = new VillagerTradeEntries();
    }

    public RegistryHelper withCreativeTab(CreativeModeTab tab) {
        this.items.addInsertListener((id, item) -> ((AccessorItem)item).bookshelf$setCreativeTab(tab));
        return this;
    }

    public abstract ICreativeTabBuilder<?> createTabBuilder(String var1);

    public abstract void init();
}

