/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.registry;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.darkhax.bookshelf.api.registry.IRegistryEntries;
import net.minecraft.resources.ResourceLocation;

public class RegistryEntries<T>
implements IRegistryEntries<T> {
    private final String ownerId;
    private final Map<ResourceLocation, T> values;
    private final Map<ResourceLocation, T> valuesUnmodifiable;
    private final List<BiConsumer<ResourceLocation, T>> insertListeners;

    public RegistryEntries(String ownerId) {
        this.ownerId = ownerId;
        this.values = new LinkedHashMap<ResourceLocation, T>();
        this.valuesUnmodifiable = Collections.unmodifiableMap(this.values);
        this.insertListeners = new LinkedList<BiConsumer<ResourceLocation, T>>();
    }

    @Override
    public <VT extends T> VT add(VT value, ResourceLocation id) {
        if (this.values.containsKey(id)) {
            throw new IllegalArgumentException("The ID " + id.toString() + " has already been registered.");
        }
        this.values.put(id, value);
        this.insertListeners.forEach(listener -> listener.accept(id, value));
        return value;
    }

    @Override
    public Map<ResourceLocation, T> getEntries() {
        return this.valuesUnmodifiable;
    }

    @Override
    public String getOwner() {
        return this.ownerId;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public void addInsertListener(BiConsumer<ResourceLocation, T> listener) {
        this.insertListeners.add(listener);
    }
}

