/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.registry;

import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.darkhax.bookshelf.api.item.ICreativeTabBuilder;
import net.darkhax.bookshelf.api.registry.IRegistryEntries;
import net.darkhax.bookshelf.api.registry.RegistryHelper;
import net.darkhax.bookshelf.impl.item.CreativeTabBuilderForge;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelperForge
extends RegistryHelper {
    public RegistryHelperForge(String ownerId) {
        super(ownerId);
    }

    @Override
    public ICreativeTabBuilder<?> createTabBuilder(String tabId) {
        return new CreativeTabBuilderForge(new ResourceLocation(this.ownerId, tabId));
    }

    @Override
    public void init() {
        this.consumeRegistry(Block.class, this.blocks);
        this.consumeRegistry(Item.class, this.items);
        this.consumeRegistry(Enchantment.class, this.enchantments);
        this.consumeRegistry(Motive.class, this.paintings);
        this.consumeRegistry(MobEffect.class, this.mobEffects);
        this.consumeRegistry(Attribute.class, this.attributes);
        this.consumeRegistry(VillagerProfession.class, this.villagerProfessions);
        this.consumeWithModEvent(RegisterClientReloadListenersEvent.class, this.clientReloadListeners, e -> this.clientReloadListeners.getEntries().values().forEach(arg_0 -> ((RegisterClientReloadListenersEvent)e).registerReloadListener(arg_0)));
        this.consumeWithEvent(AddReloadListenerEvent.class, this.serverReloadListeners, e -> this.serverReloadListeners.getEntries().values().forEach(arg_0 -> ((AddReloadListenerEvent)e).addListener(arg_0)));
        MinecraftForge.EVENT_BUS.addListener(this::buildCommands);
        MinecraftForge.EVENT_BUS.addListener(this::registerVillagerTrades);
        MinecraftForge.EVENT_BUS.addListener(this::registerWanderingTrades);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerCommandArguments);
    }

    private void registerCommandArguments(FMLCommonSetupEvent event) {
        for (Map.Entry entry : this.commandArguments.getEntries().entrySet()) {
            ArgumentTypes.m_121601_((String)entry.getKey().toString(), (Class)((Class)((Tuple)entry.getValue()).m_14418_()), (ArgumentSerializer)((ArgumentSerializer)((Tuple)entry.getValue()).m_14419_()));
        }
    }

    private void registerVillagerTrades(VillagerTradesEvent event) {
        Multimap<Integer, VillagerTrades.ItemListing> newTrades = this.trades.getVillagerTrades().get(event.getType());
        if (newTrades != null) {
            Int2ObjectMap tradeData = event.getTrades();
            for (Map.Entry entry : newTrades.entries()) {
                ((List)tradeData.computeIfAbsent((Object)((Integer)entry.getKey()), ArrayList::new)).add((VillagerTrades.ItemListing)entry.getValue());
            }
        }
    }

    private void registerWanderingTrades(WandererTradesEvent event) {
        event.getGenericTrades().addAll(this.trades.getCommonWanderingTrades());
        event.getRareTrades().addAll(this.trades.getRareWanderingTrades());
    }

    private void buildCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        boolean isDedicated = event.getEnvironment() == Commands.CommandSelection.DEDICATED;
        this.commands.forEach(builder -> builder.build((CommandDispatcher<CommandSourceStack>)dispatcher, isDedicated));
    }

    private <T extends IForgeRegistryEntry<T>> void consumeRegistry(Class<T> clazz, IRegistryEntries<T> registry) {
        if (!registry.isEmpty()) {
            Consumer<RegistryEvent.Register> listener = event -> registry.getEntries().forEach((id, value) -> {
                if (value.getRegistryName() == null) {
                    value.setRegistryName(id);
                }
                event.getRegistry().register(value);
            });
            FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(clazz, listener);
        }
    }

    private <T, E extends Event> void consumeWithModEvent(Class<E> clazz, IRegistryEntries<T> registry, Consumer<E> listener) {
        if (!registry.isEmpty()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, clazz, listener);
        }
    }

    private <T, E extends Event> void consumeWithEvent(Class<E> clazz, IRegistryEntries<T> registry, Consumer<E> listener) {
        if (!registry.isEmpty()) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, clazz, listener);
        }
    }
}

