/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.BlueprintHandler;
import com.ldtteam.structurize.client.StructureClientHandler;
import com.ldtteam.structurize.helpers.Settings;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.optifine.OptifineCompat;
import com.ldtteam.structurize.util.WorldRenderMacros;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventSubscriber {
    @SubscribeEvent
    public static void renderWorldLastEvent(RenderLevelLastEvent event) {
        LocalPlayer player;
        ItemStack itemStack;
        Tuple<BlockPos, BlockPos> box;
        Settings.instance.startStructurizePass();
        OptifineCompat.getInstance().preBlueprintDraw();
        PoseStack matrixStack = event.getPoseStack();
        float partialTicks = event.getPartialTick();
        MultiBufferSource.BufferSource bufferSource = WorldRenderMacros.getBufferSource();
        Minecraft mc = Minecraft.m_91087_();
        Vec3 viewPosition = mc.f_91063_.m_109153_().m_90583_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-viewPosition.m_7096_(), -viewPosition.m_7098_(), -viewPosition.m_7094_());
        Blueprint blueprint = Settings.instance.getActiveStructure();
        if (blueprint != null) {
            mc.m_91307_().m_6180_("struct_render");
            BlockPos pos2 = Settings.instance.getPosition();
            BlockPos posMinusOffset = pos2.m_141950_((Vec3i)blueprint.getPrimaryBlockOffset());
            StructureClientHandler.renderStructure(blueprint, partialTicks, pos2, matrixStack);
            WorldRenderMacros.renderRedGlintLineBox(bufferSource, matrixStack, pos2, pos2, 0.02f);
            WorldRenderMacros.renderWhiteLineBox(bufferSource, matrixStack, posMinusOffset, posMinusOffset.m_142082_(blueprint.getSizeX() - 1, blueprint.getSizeY() - 1, blueprint.getSizeZ() - 1), 0.02f);
            mc.m_91307_().m_7238_();
        }
        if ((box = Settings.instance.getBox()) != null) {
            mc.m_91307_().m_6180_("struct_box");
            Settings.instance.getAnchorPos().ifPresent(pos -> WorldRenderMacros.renderRedGlintLineBox(bufferSource, matrixStack, pos, pos, 0.02f));
            WorldRenderMacros.renderWhiteLineBox(bufferSource, matrixStack, (BlockPos)box.m_14418_(), (BlockPos)box.m_14419_(), 0.02f);
            mc.m_91307_().m_7238_();
        }
        if ((itemStack = (player = mc.f_91074_).m_21120_(InteractionHand.MAIN_HAND)).m_41720_() == ModItems.tagTool.get() && itemStack.m_41784_().m_128441_("anchorpostag")) {
            mc.m_91307_().m_6180_("struct_tags");
            BlockPos tagAnchor = BlockPosUtil.readFromNBT(itemStack.m_41783_(), "anchorpostag");
            BlockEntity te = mc.f_91074_.f_19853_.m_7702_(tagAnchor);
            WorldRenderMacros.renderRedGlintLineBox(bufferSource, matrixStack, tagAnchor, tagAnchor, 0.02f);
            if (te instanceof IBlueprintDataProvider) {
                Map<BlockPos, List<String>> tagPosList = ((IBlueprintDataProvider)te).getWorldTagPosMap();
                for (Map.Entry<BlockPos, List<String>> entry : tagPosList.entrySet()) {
                    WorldRenderMacros.renderWhiteLineBox(bufferSource, matrixStack, entry.getKey(), entry.getKey(), 0.02f);
                    WorldRenderMacros.renderDebugText(entry.getKey(), entry.getValue(), matrixStack, true, 3, (MultiBufferSource)bufferSource);
                }
            }
            mc.m_91307_().m_7238_();
        }
        bufferSource.m_109911_();
        matrixStack.m_85849_();
        OptifineCompat.getInstance().postBlueprintDraw();
        Settings.instance.endStructurizePass();
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft.m_91087_().m_91307_().m_6180_("structurize");
        if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_46467_() % 100L == 0L) {
            Minecraft.m_91087_().m_91307_().m_6180_("blueprint_manager_tick");
            BlueprintHandler.getInstance().cleanCache();
            Minecraft.m_91087_().m_91307_().m_7238_();
        }
        Minecraft.m_91087_().m_91307_().m_7238_();
    }
}

