/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.util.LanguageHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemCaliper
extends AbstractItemWithPosSelector {
    private static final String ITEM_CALIPER_MESSAGE_SAME = "item.caliper.message.same";
    private static final String ITEM_CALIPER_MESSAGE_BASE = "item.caliper.message.base";
    private static final String ITEM_CALIPER_MESSAGE_BY = "item.caliper.message.by";
    private static final String ITEM_CALIPER_MESSAGE_XD = "item.caliper.message.%sd";

    public ItemCaliper(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Override
    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return (AbstractItemWithPosSelector)ModItems.caliper.get();
    }

    @Override
    public InteractionResult onAirRightClick(BlockPos start, BlockPos end, Level worldIn, Player playerIn, ItemStack itemStack) {
        if (!worldIn.f_46443_) {
            return InteractionResult.FAIL;
        }
        if (start.equals((Object)end)) {
            LanguageHandler.sendMessageToPlayer(playerIn, ITEM_CALIPER_MESSAGE_SAME, new Object[0]);
            return InteractionResult.FAIL;
        }
        this.handlePlayerMessage(start, end, playerIn);
        return InteractionResult.SUCCESS;
    }

    private void handlePlayerMessage(BlockPos start, BlockPos end, Player playerIn) {
        int disX = Math.abs(end.m_123341_() - start.m_123341_());
        int disY = Math.abs(end.m_123342_() - start.m_123342_());
        int disZ = Math.abs(end.m_123343_() - start.m_123343_());
        int flag = 3;
        if (start.m_123341_() == end.m_123341_()) {
            --flag;
        }
        if (start.m_123342_() == end.m_123342_()) {
            --flag;
        }
        if (start.m_123343_() == end.m_123343_()) {
            --flag;
        }
        String by = " " + LanguageHandler.translateKey(ITEM_CALIPER_MESSAGE_BY) + " ";
        StringBuilder msg = new StringBuilder();
        if (disX != 0) {
            msg.append(++disX);
            msg.append(by);
        }
        if (disY != 0) {
            msg.append(++disY);
            msg.append(by);
        }
        if (disZ != 0) {
            msg.append(++disZ);
            msg.append(by);
        }
        msg.delete(msg.length() - by.length(), msg.length());
        msg = new StringBuilder(LanguageHandler.translateKeyWithFormat(ITEM_CALIPER_MESSAGE_BASE, msg.toString()));
        msg.append(" ");
        msg.append(LanguageHandler.translateKeyWithFormat(String.format(ITEM_CALIPER_MESSAGE_XD, flag), new Object[0]));
        LanguageHandler.sendMessageToPlayer(playerIn, msg.toString(), new Object[0]);
    }
}

