/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.placement.StructurePlacementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class BuildToolPasteMessage
implements IMessage {
    private final boolean complete;
    private final String structureName;
    private final String workOrderName;
    private final int rotation;
    private final BlockPos pos;
    private final boolean isHut;
    private final boolean mirror;

    public BuildToolPasteMessage(FriendlyByteBuf buf) {
        this.structureName = buf.m_130136_(Short.MAX_VALUE);
        this.workOrderName = buf.m_130136_(Short.MAX_VALUE);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
        this.complete = buf.readBoolean();
    }

    public BuildToolPasteMessage(String structureName, String workOrderName, BlockPos pos, Rotation rotation, boolean isHut, Mirror mirror, boolean complete) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation.ordinal();
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
        this.complete = complete;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.structureName);
        buf.m_130070_(this.workOrderName);
        buf.writeInt(this.pos.m_123341_());
        buf.writeInt(this.pos.m_123342_());
        buf.writeInt(this.pos.m_123343_());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
        buf.writeBoolean(this.complete);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        StructureName sn = new StructureName(this.structureName);
        if (!Structures.hasMD5(sn)) {
            ctxIn.getSender().m_6352_((Component)new TextComponent("Can not build " + this.workOrderName + ": schematic missing!"), ctxIn.getSender().m_142081_());
            return;
        }
        if (ctxIn.getSender().m_7500_()) {
            StructurePlacementUtils.loadAndPlaceStructureWithRotation(ctxIn.getSender().f_19853_, this.structureName, this.pos, Rotation.values()[this.rotation], this.mirror ? Mirror.FRONT_BACK : Mirror.NONE, !this.complete, ctxIn.getSender());
        }
    }
}

