/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.util.StructureUtils;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SchematicSaveMessage
implements IMessage {
    private final byte[] data;
    private final int pieces;
    private final int piece;
    private final UUID id;

    public SchematicSaveMessage(FriendlyByteBuf buf) {
        int length = buf.readInt();
        byte[] compressedData = new byte[length];
        buf.readBytes(compressedData);
        this.data = StructureUtils.uncompress(compressedData);
        this.pieces = buf.readInt();
        this.piece = buf.readInt();
        this.id = buf.m_130259_();
    }

    public SchematicSaveMessage(byte[] data, UUID id, int pieces, int piece) {
        this.data = (byte[])data.clone();
        this.id = id;
        this.pieces = pieces;
        this.piece = piece;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        byte[] compressedData = StructureUtils.compress(this.data);
        if (compressedData != null) {
            buf.capacity(compressedData.length + buf.writerIndex());
            buf.writeInt(compressedData.length);
            buf.writeBytes(compressedData);
            buf.writeInt(this.pieces);
            buf.writeInt(this.piece);
            buf.m_130077_(this.id);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return null;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (isLogicalServer) {
            boolean schematicSent;
            ServerPlayer sender = ctxIn.getSender();
            UUID senderUuid = sender.m_142081_();
            if (!((Boolean)Structurize.getConfig().getServer().allowPlayerSchematics.get()).booleanValue()) {
                Log.getLogger().info("SchematicSaveMessage: custom schematic is not allowed on this server.");
                sender.m_6352_((Component)new TextComponent("The server does not allow custom schematic!"), senderUuid);
                return;
            }
            if (this.pieces > 20) {
                Log.getLogger().error("Schematic has more than {} pieces, discarding.", (Object)20);
                sender.m_6352_((Component)new TextComponent("Schematic has more than 20 pieces, that's too big!"), senderUuid);
                return;
            }
            if (this.data == null) {
                Log.getLogger().error("Received empty schematic file");
                schematicSent = false;
            } else {
                schematicSent = Structures.handleSaveSchematicMessage(this.data, this.id, this.pieces, this.piece);
            }
            if (schematicSent) {
                sender.m_6352_((Component)new TextComponent("Schematic successfully sent!"), senderUuid);
            } else {
                sender.m_6352_((Component)new TextComponent("Failed to send the Schematic!"), senderUuid);
            }
        } else if (this.data == null) {
            Log.getLogger().error("Received empty schematic file");
        } else {
            Structures.handleSaveSchematicMessage(this.data, false);
        }
    }
}

