/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class StructurizeStylesMessage
implements IMessage {
    private final Map<String, String> md5Map;

    public StructurizeStylesMessage() {
        this.md5Map = Structures.getMD5s();
    }

    public StructurizeStylesMessage(FriendlyByteBuf buf) {
        this.md5Map = new HashMap<String, String>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            String filename = buf.m_130136_(Short.MAX_VALUE);
            String md5 = buf.m_130136_(Short.MAX_VALUE);
            this.md5Map.put(filename, md5);
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.md5Map.size());
        for (Map.Entry<String, String> entry : this.md5Map.entrySet()) {
            buf.m_130070_(entry.getKey());
            buf.m_130070_(entry.getValue());
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        Structures.init();
        Structures.setMD5s(this.md5Map);
    }
}

